/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.block;

import com.enderio.EnderIO;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.item.AdvancedTooltipProvider;
import com.enderio.core.common.util.EnergyUtil;
import com.enderio.core.common.util.TooltipUtil;
import com.enderio.machines.common.block.MachineBlock;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.blockentity.capacitorbank.CapacitorBankBlockEntity;
import com.enderio.machines.common.blockentity.capacitorbank.DisplayMode;
import com.enderio.machines.common.blockentity.multienergy.ICapacityTier;
import com.enderio.machines.common.lang.MachineLang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CapacitorBankBlock
extends MachineBlock
implements AdvancedTooltipProvider {
    private final ICapacityTier tier;
    public static final ResourceLocation PLACE_ADVANCEMENT_ID = EnderIO.loc("place_capacitor_bank");

    public ICapacityTier getTier() {
        return this.tier;
    }

    public CapacitorBankBlock(BlockBehaviour.Properties properties, BlockEntityEntry<? extends MachineBlockEntity> blockEntityType, ICapacityTier tier) {
        super(properties, blockEntityType);
        this.tier = tier;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        Direction[] directionArray;
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer != null && (directionArray = pLevel.m_7702_(pPos)) instanceof CapacitorBankBlockEntity) {
            CapacitorBankBlockEntity capacitorBankBlock = (CapacitorBankBlockEntity)directionArray;
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity = pLevel.m_7702_(pPos.m_121945_(direction));
                if (!(blockEntity instanceof CapacitorBankBlockEntity)) continue;
                CapacitorBankBlockEntity other = (CapacitorBankBlockEntity)blockEntity;
                if (other.tier != this.tier) continue;
                return;
            }
            capacitorBankBlock.setDisplayMode(pPlacer.m_6350_().m_122424_(), DisplayMode.BAR);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    @Override
    public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        String energy = String.format("%,d", EnergyUtil.getEnergyStored(itemStack)) + "/" + String.format("%,d", EnergyUtil.getMaxEnergyStored(itemStack));
        tooltips.add(TooltipUtil.styledWithArgs(EIOLang.ENERGY_AMOUNT, energy));
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        CapacitorBankBlockEntity capacitorBank;
        BlockEntity blockEntity;
        if (!event.getLevel().f_46443_ && event.getEntity().m_6144_() && (blockEntity = event.getLevel().m_7702_(event.getHitVec().m_82425_())) instanceof CapacitorBankBlockEntity && (capacitorBank = (CapacitorBankBlockEntity)blockEntity).onShiftRightClick(event.getHitVec().m_82434_(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        Player player;
        if (event.getAdvancement().m_138327_().equals((Object)PLACE_ADVANCEMENT_ID) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            @Nullable ConnectionData connectionData = NetworkHooks.getConnectionData((Connection)serverPlayer.f_8906_.f_9742_);
            if (connectionData != null && !connectionData.getModList().contains((Object)"athena")) {
                serverPlayer.m_213846_(MachineLang.MULTIBLOCK_CONNECTED_TEXTURES);
            }
        }
    }
}

