/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.EnderIO;
import com.enderio.api.misc.Icon;
import com.enderio.api.misc.Vector2i;
import com.enderio.machines.common.lang.MachineLang;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum AlloySmelterMode implements Icon
{
    FURNACE(false, true, MachineLang.ALLOY_SMELTER_MODE_FURNACE),
    ALL(true, true, MachineLang.ALLOY_SMELTER_MODE_ALL),
    ALLOYS(true, false, MachineLang.ALLOY_SMELTER_MODE_ALLOY);

    private static final ResourceLocation TEXTURE;
    private static final Vector2i SIZE;
    private final boolean canAlloy;
    private final boolean canSmelt;
    private final Vector2i pos;
    private final Component tooltip;

    private AlloySmelterMode(boolean canAlloy, boolean canSmelt, Component tooltip) {
        this.canAlloy = canAlloy;
        this.canSmelt = canSmelt;
        this.pos = new Vector2i(48 + 16 * this.ordinal(), 0);
        this.tooltip = tooltip;
    }

    public boolean canAlloy() {
        return this.canAlloy;
    }

    public boolean canSmelt() {
        return this.canSmelt;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    @Override
    public Vector2i getIconSize() {
        return SIZE;
    }

    @Override
    public Vector2i getTexturePosition() {
        return this.pos;
    }

    @Override
    public Component getTooltip() {
        return this.tooltip;
    }

    @Override
    public Vector2i getTextureSize() {
        return new Vector2i(48, 16);
    }

    static {
        TEXTURE = EnderIO.loc("textures/gui/icons/alloy_modes.png");
        SIZE = new Vector2i(16, 16);
    }
}

