/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.network.slot.BooleanNetworkDataSlot;
import com.enderio.core.common.network.slot.FluidStackNetworkDataSlot;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.FixedIOConfig;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.menu.DrainMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends PoweredMachineBlockEntity {
    public static final String CONSUMED = "Consumed";
    private static final QuadraticScalable ENERGY_CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.DRAIN_CAPACITY);
    private static final QuadraticScalable ENERGY_USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.DRAIN_USAGE);
    private static final int CAPACITY = 3000;
    private static final int ENERGY_PER_BUCKET = 1500;
    private List<BlockPos> positions;
    private int currentIndex = 0;
    private boolean fluidFound = false;
    private int consumed = 0;
    private Fluid type = Fluids.f_76191_;

    public DrainBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, ENERGY_CAPACITY, ENERGY_USAGE, type, worldPosition, blockState);
        this.addDataSlot(new FluidStackNetworkDataSlot(() -> ((FluidTank)this.getFluidTankNN()).getFluid(), arg_0 -> ((FluidTank)this.getFluidTankNN()).setFluid(arg_0)));
        this.range = 5;
        this.rangeDataSlot = new IntegerNetworkDataSlot(this::getRange, r -> {
            this.range = r;
        }){

            @Override
            public void updateServerCallback() {
                DrainBlockEntity.this.updateLocations();
            }
        };
        this.addDataSlot(this.rangeDataSlot);
        this.rangeVisibleDataSlot = new BooleanNetworkDataSlot(this::isRangeVisible, b -> {
            this.rangeVisible = b;
        });
        this.addDataSlot(this.rangeVisibleDataSlot);
    }

    @Override
    @Nullable
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().capacitor().build();
    }

    @Override
    public void serverTick() {
        if (this.isActive()) {
            this.drainFluids();
        }
        super.serverTick();
    }

    @Override
    protected IIOConfig createIOConfig() {
        return new FixedIOConfig(IOMode.PUSH);
    }

    @Override
    protected boolean isActive() {
        if (!this.canAct()) {
            return false;
        }
        FluidState fluidState = this.f_58857_.m_6425_(this.f_58858_.m_7495_());
        if (fluidState.m_76178_() || !fluidState.m_76170_()) {
            this.updateMachineState(MachineState.NO_SOURCE, true);
            return false;
        }
        this.updateMachineState(MachineState.NO_SOURCE, false);
        this.type = fluidState.m_76152_();
        return this.getFluidTankNN().fill(new FluidStack(this.type, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000;
    }

    public void drainFluids() {
        int stop = Math.min(this.currentIndex + this.range, this.positions.size());
        while (this.currentIndex < stop) {
            FluidState fluidState;
            BlockPos pos;
            if (this.currentIndex >= this.positions.size()) {
                --this.currentIndex;
            }
            if ((pos = this.positions.get(this.currentIndex)).equals((Object)this.f_58858_.m_7495_()) && this.positions.size() != 1) {
                ++this.currentIndex;
                continue;
            }
            if (this.currentIndex + 1 == this.positions.size()) {
                if (!this.fluidFound) {
                    pos = this.f_58858_.m_7495_();
                } else {
                    this.currentIndex = 0;
                    this.fluidFound = false;
                }
            }
            if ((fluidState = this.f_58857_.m_6425_(pos)).m_76178_() || !fluidState.m_76170_() || !this.getFluidTankNN().isFluidValid(new FluidStack(fluidState.m_76152_(), 1))) {
                ++this.currentIndex;
                continue;
            }
            this.fluidFound = true;
            if (this.getFluidTankNN().fill(new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE) != 1000) continue;
            if (this.consumed >= 1500) {
                this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                this.getFluidTankNN().fill(new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.EXECUTE);
                this.consumed -= 1500;
                ++this.currentIndex;
            } else {
                this.consumed += this.getEnergyStorage().consumeEnergy(1500 - this.consumed, false);
            }
            return;
        }
    }

    @Override
    public int getMaxRange() {
        return 10;
    }

    @Override
    public String getColor() {
        return (String)MachinesConfig.CLIENT.BLOCKS.DRAIN_RANGE_COLOR.get();
    }

    @Override
    public BlockPos getParticleLocation() {
        return this.f_58858_.m_6625_(this.range + 1);
    }

    @Override
    public void setRange(int range) {
        super.setRange(range);
        this.updateLocations();
    }

    public void onLoad() {
        super.onLoad();
        this.updateLocations();
    }

    private void updateLocations() {
        this.positions = new ArrayList<BlockPos>();
        this.currentIndex = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-this.range, -this.range * 2 - 1, -this.range), (BlockPos)this.f_58858_.m_7918_(this.range, -1, this.range))) {
            this.positions.add(pos.m_7949_());
        }
    }

    @Override
    @Nullable
    protected FluidTank createFluidTank() {
        return new MachineFluidTank(3000, f -> this.type.m_6212_(f.getFluid()), this){

            @Override
            protected void onContentsChanged() {
                DrainBlockEntity.this.m_6596_();
                DrainBlockEntity.this.updateMachineState(MachineState.FULL_TANK, this.getFluidAmount() >= this.getCapacity());
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new DrainMenu(this, playerInventory, containerId);
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_(CONSUMED, this.consumed);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.consumed = pTag.m_128451_(CONSUMED);
    }
}

