/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.menu.ImpulseHopperMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ImpulseHopperBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable ENERGY_CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.IMPULSE_HOPPER_CAPACITY);
    public static final QuadraticScalable ENERGY_USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.IMPULSE_HOPPER_USAGE);
    private static final int ENERGY_USAGE_PER_ITEM = 10;
    public static final MultiSlotAccess INPUT = new MultiSlotAccess();
    public static final MultiSlotAccess OUTPUT = new MultiSlotAccess();
    public static final MultiSlotAccess GHOST = new MultiSlotAccess();

    public ImpulseHopperBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, ENERGY_CAPACITY, ENERGY_USAGE, type, worldPosition, blockState);
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new ImpulseHopperMenu(this, inventory, containerId);
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot(6, (integer, itemStack) -> ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)GHOST.get((int)integer).getItemStack(this))).slotAccess(INPUT).outputSlot(6).slotAccess(OUTPUT).ghostSlot(6).slotAccess(GHOST).capacitor().build();
    }

    @Override
    public void serverTick() {
        if (this.shouldActTick() && this.shouldPassItems()) {
            this.passItems();
        }
        super.serverTick();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy();
    }

    public boolean shouldActTick() {
        return this.canAct() && this.f_58857_.m_46467_() % (long)this.ticksForAction() == 0L;
    }

    public int ticksForAction() {
        return 20;
    }

    public boolean canPass(int slot) {
        ItemStack ghost;
        ItemStack input = INPUT.get(slot).getItemStack(this);
        if (ItemStack.m_150942_((ItemStack)input, (ItemStack)(ghost = GHOST.get(slot).getItemStack(this)))) {
            return input.m_41613_() >= ghost.m_41613_();
        }
        return false;
    }

    public boolean canHoldAndMerge(int slot) {
        boolean canHold = OUTPUT.get(slot).getItemStack(this).m_41613_() + GHOST.get(slot).getItemStack(this).m_41613_() <= GHOST.get(slot).getItemStack(this).m_41741_();
        boolean canMerge = ItemStack.m_150942_((ItemStack)INPUT.get(slot).getItemStack(this), (ItemStack)GHOST.get(slot).getItemStack(this));
        return canHold && canMerge;
    }

    public boolean shouldPassItems() {
        int totalpower = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.canPass(i) && this.canHoldAndMerge(i)) {
                totalpower += GHOST.get(i).getItemStack(this).m_41613_() * 10;
                continue;
            }
            return false;
        }
        return this.getEnergyStorage().consumeEnergy(totalpower, true) > 0;
    }

    private void passItems() {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = INPUT.get(i).getItemStack(this);
            ItemStack ghost = GHOST.get(i).getItemStack(this);
            ItemStack result = OUTPUT.get(i).getItemStack(this);
            if (ghost.m_41619_()) continue;
            if (result.m_41619_()) {
                result = stack.m_41777_();
                result.m_41764_(ghost.m_41613_());
            } else if (stack.m_150930_(result.m_41720_())) {
                result.m_41764_(result.m_41613_() + ghost.m_41613_());
            }
            this.getEnergyStorage().consumeEnergy(ghost.m_41613_() * 10, false);
            stack.m_41774_(ghost.m_41613_());
            OUTPUT.get(i).setStackInSlot(this, result);
        }
    }

    public boolean ghostSlotHasItem(int slot) {
        return GHOST.get(slot).getItemStack(this).m_41619_();
    }
}

