/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.lang.EIOLang;
import com.enderio.machines.common.blockentity.MachineStateType;
import com.enderio.machines.common.lang.MachineLang;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public record MachineState(MachineStateType type, MutableComponent component) {
    public static final MachineState ACTIVE = new MachineState(MachineStateType.ACTIVE, MachineLang.TOOLTIP_ACTIVE);
    public static final MachineState IDLE = new MachineState(MachineStateType.IDLE, MachineLang.TOOLTIP_IDLE);
    public static final MachineState EMPTY_INPUT = new MachineState(MachineStateType.IDLE, MachineLang.TOOLTIP_INPUT_EMPTY);
    public static final MachineState NO_SOURCE = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_NO_SOURCE);
    public static final MachineState EMPTY_TANK = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_EMPTY_TANK);
    public static final MachineState FULL_TANK = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_FULL_TANK);
    public static final MachineState NO_POWER = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_NO_POWER);
    public static final MachineState FULL_POWER = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_FULL_POWER);
    public static final MachineState NO_CAPACITOR = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_NO_CAPACITOR);
    public static final MachineState NOT_SOULBOUND = new MachineState(MachineStateType.ERROR, EIOLang.TOOLTIP_NO_SOULBOUND);
    public static final MachineState FULL_OUTPUT = new MachineState(MachineStateType.ERROR, MachineLang.TOOLTIP_OUTPUT_FULL);
    public static final MachineState REDSTONE = new MachineState(MachineStateType.DISABLED, MachineLang.TOOLTIP_BLOCKED_RESTONE);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineState that = (MachineState)o;
        if (this.type != that.type) {
            return false;
        }
        return this.component.equals((Object)that.component);
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.component.hashCode();
        return result;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Type", this.type.name());
        nbt.m_128359_("Compound", this.component.getString());
        tag.m_128365_("MachineState", (Tag)nbt);
        return tag;
    }

    public static MachineState fromNBT(CompoundTag tag) {
        CompoundTag nbt;
        if (tag.m_128441_("MachineState") && (nbt = tag.m_128469_("MachineState")).m_128441_("Type") && nbt.m_128441_("Compound")) {
            return new MachineState(MachineStateType.valueOf(nbt.m_128461_("Type")), Component.m_237115_((String)nbt.m_128461_("Compound")));
        }
        return new MachineState(MachineStateType.ACTIVE, MachineLang.TOOLTIP_ACTIVE);
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.type.name());
        buf.m_130070_(this.component.getString());
    }

    public static MachineState fromBuffer(FriendlyByteBuf buf) {
        return new MachineState(MachineStateType.valueOf(buf.m_130277_()), Component.m_237115_((String)buf.m_130277_()));
    }
}

