/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.base;

import com.enderio.api.capacitor.CapacitorData;
import com.enderio.api.capacitor.CapacitorScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.blockentity.MachineInstallable;
import com.enderio.base.common.capacitor.CapacitorUtil;
import com.enderio.base.common.capacitor.DefaultCapacitorData;
import com.enderio.base.common.item.capacitors.CapacitorItem;
import com.enderio.core.common.network.slot.NetworkDataSlot;
import com.enderio.machines.common.block.ProgressMachineBlock;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.blockentity.sync.MachineEnergyNetworkDataSlot;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.enderio.machines.common.io.energy.ImmutableMachineEnergyStorage;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public abstract class PoweredMachineBlockEntity
extends MachineBlockEntity
implements MachineInstallable {
    protected final MachineEnergyStorage energyStorage;
    @Nullable
    protected final MachineEnergyStorage exposedEnergyStorage;
    protected IMachineEnergyStorage clientEnergyStorage = ImmutableMachineEnergyStorage.EMPTY;
    private CapacitorData cachedCapacitorData = DefaultCapacitorData.NONE;
    private boolean capacitorCacheDirty;
    private boolean updateModel = false;

    public PoweredMachineBlockEntity(EnergyIOMode energyIOMode, CapacitorScalable capacity, CapacitorScalable usageRate, BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.energyStorage = this.createEnergyStorage(energyIOMode, capacity.scaleI(this::getCapacitorData), usageRate.scaleI(this::getCapacitorData));
        this.exposedEnergyStorage = this.createExposedEnergyStorage();
        if (this.exposedEnergyStorage != null) {
            this.addCapabilityProvider(this.exposedEnergyStorage);
        }
        this.capacitorCacheDirty = true;
        this.addDataSlot(this.createEnergyDataSlot());
    }

    public NetworkDataSlot<?> createEnergyDataSlot() {
        return new MachineEnergyNetworkDataSlot(this::getExposedEnergyStorage, storage -> {
            this.clientEnergyStorage = storage;
        });
    }

    @Override
    public void serverTick() {
        if (this.canAct()) {
            this.pushEnergy();
        }
        if (this.f_58857_ != null) {
            BlockState blockState = this.m_58900_();
            if (blockState.m_61138_((Property)ProgressMachineBlock.POWERED) && ((Boolean)blockState.m_61143_((Property)ProgressMachineBlock.POWERED)).booleanValue() != this.isActive()) {
                if (this.updateModel) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)ProgressMachineBlock.POWERED, (Comparable)Boolean.valueOf(this.isActive())), 3);
                    this.updateMachineState(MachineState.ACTIVE, this.isActive());
                }
                this.updateModel = true;
            } else {
                this.updateModel = false;
            }
        }
        super.serverTick();
    }

    protected abstract boolean isActive();

    public final IMachineEnergyStorage getEnergyStorage() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return this.clientEnergyStorage;
        }
        return this.energyStorage;
    }

    public final boolean hasEnergy() {
        if (this.requiresCapacitor() && !this.isCapacitorInstalled()) {
            return false;
        }
        return this.getEnergyStorage().getEnergyStored() > 0;
    }

    public final IMachineEnergyStorage getExposedEnergyStorage() {
        if (this.exposedEnergyStorage != null) {
            return this.exposedEnergyStorage;
        }
        return this.getEnergyStorage();
    }

    @Nullable
    public MachineEnergyStorage createExposedEnergyStorage() {
        return this.energyStorage;
    }

    private void pushEnergy() {
        if (!this.getExposedEnergyStorage().getIOMode().canOutput()) {
            return;
        }
        for (Direction side : Direction.values()) {
            if (!this.shouldPushEnergyTo(side)) continue;
            this.getCapability(ForgeCapabilities.ENERGY, side).resolve().ifPresent(selfHandler -> {
                Optional otherHandler = this.getNeighbouringCapability(ForgeCapabilities.ENERGY, side).resolve();
                if (otherHandler.isPresent()) {
                    if (selfHandler == otherHandler.get()) {
                        return;
                    }
                    if (((IEnergyStorage)otherHandler.get()).canReceive()) {
                        int received = ((IEnergyStorage)otherHandler.get()).receiveEnergy(selfHandler.getEnergyStored(), false);
                        this.getExposedEnergyStorage().takeEnergy(received);
                    }
                }
            });
        }
    }

    protected boolean shouldPushEnergyTo(Direction direction) {
        return true;
    }

    protected MachineEnergyStorage createEnergyStorage(EnergyIOMode energyIOMode, Supplier<Integer> capacity, Supplier<Integer> usageRate) {
        return new MachineEnergyStorage(this.getIOConfig(), energyIOMode, capacity, usageRate){

            @Override
            protected void onContentsChanged() {
                PoweredMachineBlockEntity.this.m_6596_();
                PoweredMachineBlockEntity.this.updateMachineState(MachineState.NO_POWER, PoweredMachineBlockEntity.this.getEnergyStorage().getEnergyStored() <= 0);
            }
        };
    }

    @Override
    public InteractionResult tryItemInstall(ItemStack stack, UseOnContext context) {
        if (stack.m_41720_() instanceof CapacitorItem && this.requiresCapacitor() && !this.isCapacitorInstalled()) {
            MachineInventory inventory = this.getInventory();
            MachineInventoryLayout layout = this.getInventoryLayout();
            if (inventory != null && layout != null) {
                inventory.setStackInSlot(layout.getCapacitorSlot(), stack.m_255036_(1));
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public final boolean requiresCapacitor() {
        MachineInventoryLayout layout = this.getInventoryLayout();
        if (layout == null) {
            return false;
        }
        return layout.supportsCapacitor();
    }

    public final int getCapacitorSlot() {
        MachineInventoryLayout layout = this.getInventoryLayout();
        if (layout == null) {
            return -1;
        }
        return layout.getCapacitorSlot();
    }

    public boolean isCapacitorInstalled() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return !this.getCapacitorItem().m_41619_();
        }
        if (this.capacitorCacheDirty) {
            this.cacheCapacitorData();
        }
        return this.cachedCapacitorData != DefaultCapacitorData.NONE;
    }

    public ItemStack getCapacitorItem() {
        MachineInventory inventory = this.getInventory();
        MachineInventoryLayout layout = this.getInventoryLayout();
        if (inventory == null || layout == null) {
            return ItemStack.f_41583_;
        }
        return inventory.getStackInSlot(layout.getCapacitorSlot());
    }

    public CapacitorData getCapacitorData() {
        if (this.capacitorCacheDirty) {
            this.cacheCapacitorData();
        }
        return this.cachedCapacitorData;
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        MachineInventoryLayout inventoryLayout = this.getInventoryLayout();
        if (inventoryLayout != null && inventoryLayout.getCapacitorSlot() == slot && this.requiresCapacitor()) {
            this.updateMachineState(MachineState.NO_CAPACITOR, this.getCapacitorItem().m_41619_());
            this.capacitorCacheDirty = true;
        }
        super.onInventoryContentsChanged(slot);
    }

    private void cacheCapacitorData() {
        if (this.f_58857_ == null) {
            return;
        }
        this.capacitorCacheDirty = false;
        MachineInventoryLayout layout = this.getInventoryLayout();
        this.cachedCapacitorData = this.requiresCapacitor() && layout != null ? CapacitorUtil.getCapacitorData(this.getCapacitorItem()).orElse(DefaultCapacitorData.NONE) : DefaultCapacitorData.NONE;
    }

    @Override
    public boolean canAct() {
        return super.canAct() && (!this.requiresCapacitor() || this.isCapacitorInstalled());
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        IMachineEnergyStorage energyStorage = this.getEnergyStorage();
        if (energyStorage instanceof MachineEnergyStorage) {
            MachineEnergyStorage storage = (MachineEnergyStorage)energyStorage;
            pTag.m_128365_("Energy", (Tag)storage.serializeNBT());
        }
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        IMachineEnergyStorage energyStorage = this.getEnergyStorage();
        if (energyStorage instanceof MachineEnergyStorage) {
            MachineEnergyStorage storage = (MachineEnergyStorage)energyStorage;
            if (pTag.m_128441_("Energy")) {
                storage.deserializeNBT(pTag.m_128469_("Energy"));
            }
        }
        super.m_142466_(pTag);
        this.cacheCapacitorData();
        this.updateMachineState(MachineState.NO_CAPACITOR, this.requiresCapacitor() && this.getCapacitorItem().m_41619_());
        this.updateMachineState(MachineState.NO_POWER, energyStorage.getEnergyStored() <= 0);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateMachineState(MachineState.NO_CAPACITOR, this.requiresCapacitor() && this.getCapacitorItem().m_41619_());
        this.updateMachineState(MachineState.NO_POWER, this.energyStorage.getEnergyStored() <= 0);
    }
}

