/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.solar;

import com.enderio.api.capacitor.FixedScalable;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.multienergy.MultiEnergyNode;
import com.enderio.machines.common.blockentity.multienergy.MultiEnergyStorageWrapper;
import com.enderio.machines.common.blockentity.solar.ISolarPanelTier;
import com.enderio.machines.common.io.SidedFixedIOConfig;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends PoweredMachineBlockEntity {
    private final ISolarPanelTier tier;
    private final MultiEnergyNode node;

    public SolarPanelBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState, ISolarPanelTier tier) {
        super(EnergyIOMode.Output, new FixedScalable(tier::getStorageCapacity), new FixedScalable(tier::getStorageCapacity), type, worldPosition, blockState);
        this.tier = tier;
        this.node = new MultiEnergyNode(() -> this.energyStorage, () -> (MultiEnergyStorageWrapper)this.getExposedEnergyStorage(), worldPosition);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return null;
    }

    @Override
    @Nullable
    public MachineEnergyStorage createExposedEnergyStorage() {
        return new MultiEnergyStorageWrapper(this.createIOConfig(), EnergyIOMode.Output, () -> this.tier);
    }

    @Override
    public void serverTick() {
        if (this.isGenerating()) {
            this.getEnergyStorage().addEnergy(this.getGenerationRate());
        }
        super.serverTick();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.isGenerating();
    }

    public boolean isGenerating() {
        if (this.f_58857_ == null || !this.f_58857_.m_45527_(this.m_58899_().m_7494_())) {
            return false;
        }
        return this.getGenerationRate() > 0;
    }

    public int getGenerationRate() {
        int minuteInTicks = 1200;
        if (this.f_58857_ == null) {
            return 0;
        }
        int dayTime = (int)(this.f_58857_.m_46468_() % (long)(minuteInTicks * 20));
        if (dayTime > minuteInTicks * 9) {
            return 0;
        }
        if (dayTime < minuteInTicks) {
            return 0;
        }
        float progress = dayTime > minuteInTicks * 5 ? (float)(10 * minuteInTicks - dayTime) : (float)dayTime;
        progress = (progress - (float)minuteInTicks) / (float)(4 * minuteInTicks);
        double easing = SolarPanelBlockEntity.easing(progress);
        if (this.f_58857_.m_46471_() && !this.f_58857_.m_46470_()) {
            easing -= (double)0.3f;
        }
        if (this.f_58857_.m_46470_()) {
            easing -= (double)0.7f;
        }
        if (easing < 0.0) {
            return 0;
        }
        return (int)(easing * (double)this.tier.getProductionRate());
    }

    @Override
    protected boolean shouldPushEnergyTo(Direction direction) {
        if (this.node.getGraph() == null) {
            return true;
        }
        for (GraphObject neighbour : this.node.getGraph().getNeighbours((GraphObject)this.node)) {
            if (!(neighbour instanceof MultiEnergyNode)) continue;
            MultiEnergyNode node = (MultiEnergyNode)neighbour;
            if (!node.pos.equals((Object)this.f_58858_.m_121945_(direction))) continue;
            return false;
        }
        return true;
    }

    public void m_7651_() {
        if (this.node.getGraph() != null) {
            this.node.getGraph().remove((GraphObject)this.node);
        }
        super.m_7651_();
    }

    public void onLoad() {
        super.onLoad();
        if (this.node.getGraph() == null) {
            Graph.integrate((GraphObject)this.node, List.of());
        }
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (!(blockEntity instanceof SolarPanelBlockEntity)) continue;
            SolarPanelBlockEntity panel = (SolarPanelBlockEntity)blockEntity;
            if (panel.tier != this.tier) continue;
            Graph.connect((GraphObject)this.node, (GraphObject)panel.node);
        }
    }

    private static double easing(float progress) {
        if (progress > 0.5f) {
            return 1.0 - Math.pow(-2.0f * progress + 2.0f, 2.0) / 2.0;
        }
        return 2.0f * progress * progress;
    }

    @Override
    protected IIOConfig createIOConfig() {
        return new SidedFixedIOConfig(dir -> dir == Direction.UP ? IOMode.NONE : IOMode.PUSH);
    }

    @Override
    public boolean canOpenMenu() {
        return false;
    }
}

