/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei;

import com.enderio.EnderIO;
import com.enderio.base.common.integrations.jei.subtype.EntityStorageSubtypeInterpreter;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.init.MachineMenus;
import com.enderio.machines.common.integrations.jei.MachineJEIRecipes;
import com.enderio.machines.common.integrations.jei.category.AlloySmeltingCategory;
import com.enderio.machines.common.integrations.jei.category.EnchanterCategory;
import com.enderio.machines.common.integrations.jei.category.PrimitiveAlloySmeltingCategory;
import com.enderio.machines.common.integrations.jei.category.SagMillCategory;
import com.enderio.machines.common.integrations.jei.category.SlicingRecipeCategory;
import com.enderio.machines.common.integrations.jei.category.SoulBindingCategory;
import com.enderio.machines.common.integrations.jei.category.SoulEngineCategory;
import com.enderio.machines.common.integrations.jei.category.TankCategory;
import com.enderio.machines.common.integrations.jei.transfer.CrafterRecipeTransferHandler;
import com.enderio.machines.common.menu.AlloySmelterMenu;
import com.enderio.machines.common.menu.EnchanterMenu;
import com.enderio.machines.common.menu.PrimitiveAlloySmelterMenu;
import com.enderio.machines.common.menu.SagMillMenu;
import com.enderio.machines.common.menu.SlicerMenu;
import com.enderio.machines.common.menu.SoulBinderMenu;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class MachinesJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return EnderIO.loc("machines");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.PRIMITIVE_ALLOY_SMELTER.get()), new RecipeType[]{PrimitiveAlloySmeltingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.ALLOY_SMELTER.get()), new RecipeType[]{AlloySmeltingCategory.TYPE, RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.ENCHANTER.get()), new RecipeType[]{EnchanterCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.SAG_MILL.get()), new RecipeType[]{SagMillCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.SLICE_AND_SPLICE.get()), new RecipeType[]{SlicingRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.SOUL_BINDER.get()), new RecipeType[]{SoulBindingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.FLUID_TANK.get()), new RecipeType[]{TankCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.PRESSURIZED_FLUID_TANK.get()), new RecipeType[]{TankCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachineBlocks.SOUL_ENGINE.get()), new RecipeType[]{SoulEngineCategory.TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AlloySmeltingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnchanterCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PrimitiveAlloySmeltingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SagMillCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SlicingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoulBindingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TankCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoulEngineCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        MachineJEIRecipes recipes = new MachineJEIRecipes();
        registration.addRecipes(AlloySmeltingCategory.TYPE, recipes.getAlloySmeltingRecipesWithSmelting());
        registration.addRecipes(EnchanterCategory.TYPE, recipes.getEnchanterRecipes());
        registration.addRecipes(PrimitiveAlloySmeltingCategory.TYPE, recipes.getAlloySmeltingRecipes());
        registration.addRecipes(SagMillCategory.TYPE, recipes.getSagMillingRecipes());
        registration.addRecipes(SlicingRecipeCategory.TYPE, recipes.getSlicingRecipes());
        registration.addRecipes(SoulBindingCategory.TYPE, recipes.getSoulBindingRecipes());
        registration.addRecipes(TankCategory.TYPE, recipes.getTankRecipes());
        registration.addRecipes(SoulEngineCategory.TYPE, recipes.getMobGeneratorRecipes());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AlloySmelterMenu.class, (MenuType)MachineMenus.ALLOY_SMELTER.get(), AlloySmeltingCategory.TYPE, AlloySmelterMenu.INPUTS_INDEX, AlloySmelterMenu.INPUT_COUNT, AlloySmelterMenu.LAST_INDEX + 1, 36);
        registration.addRecipeTransferHandler(EnchanterMenu.class, (MenuType)MachineMenus.ENCHANTER.get(), EnchanterCategory.TYPE, EnchanterMenu.INPUTS_INDEX, EnchanterMenu.INPUT_COUNT, EnchanterMenu.LAST_INDEX + 1, 36);
        registration.addRecipeTransferHandler(PrimitiveAlloySmelterMenu.class, (MenuType)MachineMenus.PRIMITIVE_ALLOY_SMELTER.get(), AlloySmeltingCategory.TYPE, PrimitiveAlloySmelterMenu.INPUTS_INDEX, PrimitiveAlloySmelterMenu.INPUT_COUNT, PrimitiveAlloySmelterMenu.LAST_INDEX + 1, 36);
        registration.addRecipeTransferHandler(SagMillMenu.class, (MenuType)MachineMenus.SAG_MILL.get(), SagMillCategory.TYPE, SagMillMenu.INPUTS_INDEX, SagMillMenu.INPUT_COUNT, SagMillMenu.LAST_INDEX + 1, 36);
        registration.addRecipeTransferHandler(SlicerMenu.class, (MenuType)MachineMenus.SLICE_N_SPLICE.get(), SlicingRecipeCategory.TYPE, SlicerMenu.INPUTS_INDEX, SlicerMenu.INPUT_COUNT, SlicerMenu.LAST_INDEX + 1, 36);
        registration.addRecipeTransferHandler(SoulBinderMenu.class, (MenuType)MachineMenus.SOUL_BINDER.get(), SoulBindingCategory.TYPE, SoulBinderMenu.INPUTS_INDEX, SoulBinderMenu.INPUT_COUNT, SoulBinderMenu.LAST_INDEX + 1, 36);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CrafterRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(MachineBlocks.SOUL_ENGINE.m_5456_(), (IIngredientSubtypeInterpreter)new EntityStorageSubtypeInterpreter());
    }
}

