/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.api.grindingball.GrindingBallData;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.util.GrindingBallManager;
import com.enderio.core.common.util.TooltipUtil;
import com.enderio.machines.client.gui.screen.SagMillScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.integrations.jei.util.MachineRecipeCategory;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.recipe.SagMillingRecipe;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SagMillCategory
extends MachineRecipeCategory<SagMillingRecipe> {
    public static final RecipeType<SagMillingRecipe> TYPE = RecipeType.create((String)"enderio", (String)"sagmilling", SagMillingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SagMillCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SagMillScreen.BG_TEXTURE, 48, 11, 123, 65);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.SAG_MILL.get()));
    }

    public RecipeType<SagMillingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_SAG_MILL;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SagMillingRecipe recipe, IFocusGroup focuses) {
        List<SagMillingRecipe.OutputItem> results;
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 1).addItemStacks(List.of(recipe.getInput().m_43908_()));
        IRecipeSlotBuilder gridingBallSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 74, 12).addItemStack(new ItemStack((ItemLike)Items.f_41852_));
        if (recipe.getBonusType().useGrindingBall()) {
            gridingBallSlot.addItemStacks(GrindingBallManager.getGrindingBalls().stream().map(ItemStack::new).toList());
        }
        if (!(results = recipe.getOutputs()).isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 48).addItemStack(results.get(0).getItemStack())).addTooltipCallback(this.chanceTooltip(recipe, results.get(0)));
        }
        if (results.size() > 1) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 22, 48).addItemStack(results.get(1).getItemStack())).addTooltipCallback(this.chanceTooltip(recipe, results.get(1)));
        }
        if (results.size() > 2) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 43, 48).addItemStack(results.get(2).getItemStack())).addTooltipCallback(this.chanceTooltip(recipe, results.get(2)));
        }
        if (results.size() > 3) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 64, 48).addItemStack(results.get(3).getItemStack())).addTooltipCallback(this.chanceTooltip(recipe, results.get(3)));
        }
    }

    private IRecipeSlotTooltipCallback chanceTooltip(SagMillingRecipe recipe, SagMillingRecipe.OutputItem item) {
        return (recipeSlotView, tooltip) -> {
            if (item.getChance() < 1.0f) {
                String chance;
                String string = chance = item.getChance() > 0.01f ? NumberFormat.getIntegerInstance(Locale.ENGLISH).format(item.getChance() * 100.0f) : "<1";
                if (recipe.getBonusType().useGrindingBall()) {
                    tooltip.add(TooltipUtil.styledWithArgs(MachineLang.TOOLTIP_SAG_MILL_CHANCE_BALL, chance));
                } else {
                    tooltip.add(TooltipUtil.styledWithArgs(MachineLang.TOOLTIP_SAG_MILL_CHANCE, chance));
                }
            }
        };
    }

    public void draw(SagMillingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.getEnergyString(recipe, recipeSlotsView), 83, 47, -8355712, false);
    }

    public List<Component> getTooltipStrings(SagMillingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mouseX > 83.0 && mouseY > 47.0 && mouseX < (double)(83 + mc.f_91062_.m_92852_((FormattedText)this.getEnergyString(recipe, recipeSlotsView)))) {
            Objects.requireNonNull(mc.f_91062_);
            if (mouseY < (double)(47 + 9)) {
                return List.of(MachineLang.TOOLTIP_ENERGY_EQUIVALENCE);
            }
        }
        return List.of();
    }

    private Component getEnergyString(SagMillingRecipe recipe, IRecipeSlotsView recipeSlotsView) {
        return TooltipUtil.withArgs(EIOLang.ENERGY_AMOUNT, NumberFormat.getIntegerInstance(Locale.ENGLISH).format(recipe.getEnergyCost(((IRecipeSlotView)recipeSlotsView.getSlotViews().get(1)).getDisplayedItemStack().map(GrindingBallManager::getData).orElse(GrindingBallData.IDENTITY))));
    }
}

