/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.item.tool.SoulVialItem;
import com.enderio.machines.client.gui.screen.SoulBinderScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.integrations.jei.util.MachineRecipeCategory;
import com.enderio.machines.common.integrations.jei.util.RecipeUtil;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.recipe.SoulBindingRecipe;
import com.enderio.machines.common.souldata.SoulData;
import com.enderio.machines.common.souldata.SoulDataReloadListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SoulBindingCategory
extends MachineRecipeCategory<SoulBindingRecipe> {
    public static final RecipeType<SoulBindingRecipe> TYPE = RecipeType.create((String)"enderio", (String)"soul_binding", SoulBindingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SoulBindingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SoulBinderScreen.BG_TEXTURE, 35, 30, 118, 44);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.SOUL_BINDER.get()));
    }

    public RecipeType<SoulBindingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_SOUL_BINDING;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SoulBindingRecipe recipe, IFocusGroup focuses) {
        ArrayList<ItemStack> vials = new ArrayList<ItemStack>();
        Optional output = focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).findFirst();
        Optional<IFocus> input = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).filter(f -> ((ItemStack)f.getTypedValue().getItemStack().get()).m_150930_(EIOItems.FILLED_SOUL_VIAL.m_5456_())).findFirst();
        if (input.isPresent()) {
            vials.add((ItemStack)input.get().getTypedValue().getIngredient());
        } else if (recipe.getEntityType() != null) {
            item = new ItemStack(EIOItems.FILLED_SOUL_VIAL);
            SoulVialItem.setEntityType(item, recipe.getEntityType());
            vials.add(item);
        } else if (recipe.getMobCategory() != null) {
            List<ResourceLocation> allEntitiesOfCategory = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(e -> e.m_20674_().equals((Object)recipe.getMobCategory())).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).toList();
            for (ResourceLocation entity : allEntitiesOfCategory) {
                ItemStack item = new ItemStack(EIOItems.FILLED_SOUL_VIAL);
                SoulVialItem.setEntityType(item, entity);
                vials.add(item);
            }
        } else if (recipe.getSouldata() != null) {
            if (output.isPresent()) {
                item = new ItemStack(EIOItems.FILLED_SOUL_VIAL);
                ((ItemStack)((IFocus)output.get()).getTypedValue().getItemStack().get()).getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(cap -> {
                    SoulVialItem.setEntityType(item, cap.getStoredEntityData().getEntityType().get());
                    vials.add(item);
                });
            } else {
                SoulDataReloadListener<SoulData> soulDataReloadListener = SoulDataReloadListener.fromString(recipe.getSouldata());
                List<ResourceLocation> allEntitiesOfSoulData = ForgeRegistries.ENTITY_TYPES.getKeys().stream().filter(r -> soulDataReloadListener.map.containsKey(r)).toList();
                for (ResourceLocation entity : allEntitiesOfSoulData) {
                    ItemStack item = new ItemStack(EIOItems.FILLED_SOUL_VIAL);
                    SoulVialItem.setEntityType(item, entity);
                    vials.add(item);
                }
            }
        } else if (output.isPresent()) {
            item = new ItemStack(EIOItems.FILLED_SOUL_VIAL);
            ((ItemStack)((IFocus)output.get()).getTypedValue().getItemStack().get()).getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(cap -> {
                SoulVialItem.setEntityType(item, cap.getStoredEntityData().getEntityType().get());
                vials.add(item);
            });
        } else {
            vials.addAll(SoulVialItem.getAllFilled());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 4).addItemStacks(vials);
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 4).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 77, 4).addItemStack(new ItemStack(EIOItems.EMPTY_SOUL_VIAL));
        ItemStack resultStack = RecipeUtil.getResultStacks(recipe).get(0).getItem();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (resultStack.getCapability(EIOCapabilities.ENTITY_STORAGE).isPresent()) {
            for (ItemStack vial : vials) {
                SoulVialItem.getEntityData(vial).flatMap(StoredEntityData::getEntityType).ifPresent(entityType -> {
                    ItemStack result = resultStack.m_41777_();
                    result.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storage -> {
                        storage.setStoredEntityData(StoredEntityData.of(entityType));
                        results.add(result);
                    });
                });
            }
        }
        if (results.size() == 0) {
            results.add(resultStack);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 4).addItemStacks(results);
    }

    public void draw(SoulBindingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        int cost = recipe.getExpCost();
        String costText = cost < 0 ? "err" : Integer.toString(cost);
        String text = I18n.m_118938_((String)"container.repair.cost", (Object[])new Object[]{costText});
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        int mainColor = SoulBindingCategory.playerHasEnoughLevels(player, cost) ? -8323296 : -40864;
        guiGraphics.m_280488_(minecraft.f_91062_, text, 5, 24, mainColor);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, SoulBindingCategory.getBasicEnergyString(recipe), 5, 34, -8355712, false);
    }

    public List<Component> getTooltipStrings(SoulBindingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mouseX > 5.0 && mouseY > 34.0 && mouseX < (double)(5 + mc.f_91062_.m_92852_((FormattedText)SoulBindingCategory.getBasicEnergyString(recipe)))) {
            Objects.requireNonNull(mc.f_91062_);
            if (mouseY < (double)(34 + 9)) {
                return List.of(MachineLang.TOOLTIP_ENERGY_EQUIVALENCE);
            }
        }
        return List.of();
    }
}

