/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.vanilla;

import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.blockentity.AlloySmelterBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class VanillaAlloySmeltingRecipe
extends AlloySmeltingRecipe {
    private final SmeltingRecipe vanillaRecipe;

    public VanillaAlloySmeltingRecipe(SmeltingRecipe vanillaRecipe) {
        super(vanillaRecipe.m_6423_(), List.of(), ItemStack.f_41583_, 0, 0.0f);
        this.vanillaRecipe = vanillaRecipe;
    }

    @Override
    public List<CountedIngredient> getInputs() {
        return List.of(CountedIngredient.of((Ingredient)this.vanillaRecipe.m_7527_().get(0)));
    }

    @Override
    public int getBaseEnergyCost() {
        return (Integer)MachinesConfig.COMMON.ENERGY.ALLOY_SMELTER_VANILLA_ITEM_ENERGY.get();
    }

    @Override
    public int getEnergyCost(AlloySmeltingRecipe.ContainerWrapper container) {
        return this.getBaseEnergyCost() * container.getInputsTaken();
    }

    @Override
    public float getExperience() {
        return this.vanillaRecipe.m_43750_();
    }

    @Override
    public boolean matches(AlloySmeltingRecipe.ContainerWrapper container, Level level) {
        for (int i = 0; i < AlloySmelterBlockEntity.INPUTS.size(); ++i) {
            if (!this.vanillaRecipe.m_5818_((Container)new AlloySmelterBlockEntity.ContainerSubWrapper(container, i), level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<OutputStack> craft(AlloySmeltingRecipe.ContainerWrapper container, RegistryAccess registryAccess) {
        ItemStack result = this.vanillaRecipe.m_5874_((Container)container, registryAccess);
        result.m_41764_(result.m_41613_() * container.getInputsTaken());
        return List.of(OutputStack.of(result));
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        return List.of(OutputStack.of(this.vanillaRecipe.m_8043_(registryAccess)));
    }

    @Override
    @Deprecated
    public RecipeSerializer<?> m_7707_() {
        throw new UnsupportedOperationException("Cannot serialize a wrapped recipe!");
    }

    @Override
    public RecipeType<?> m_6671_() {
        return this.vanillaRecipe.m_6671_();
    }

    public boolean equals(Object obj) {
        SmeltingRecipe recipe;
        if (obj instanceof SmeltingRecipe && (recipe = (SmeltingRecipe)obj).equals(this.vanillaRecipe)) {
            return true;
        }
        if (obj instanceof VanillaAlloySmeltingRecipe) {
            VanillaAlloySmeltingRecipe alloySmeltingRecipe = (VanillaAlloySmeltingRecipe)obj;
            if (this.vanillaRecipe.equals(alloySmeltingRecipe.vanillaRecipe)) {
                return true;
            }
        }
        return super.equals(obj);
    }
}

