/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import com.enderio.api.capability.IEnderCapabilityProvider;
import com.enderio.api.io.IIOConfig;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class MachineFluidHandler
implements IFluidHandler,
IEnderCapabilityProvider<IFluidHandler> {
    private final IIOConfig config;
    private final List<IFluidTank> tanks;
    private final EnumMap<Direction, LazyOptional<Sided>> sideCache = new EnumMap(Direction.class);
    private LazyOptional<MachineFluidHandler> selfCache = LazyOptional.empty();

    public MachineFluidHandler(IIOConfig config, IFluidTank ... tanks) {
        this.config = config;
        this.tanks = List.of(tanks);
    }

    public final IIOConfig getConfig() {
        return this.config;
    }

    public final IFluidTank getTank(int tank) {
        return this.tanks.get(tank);
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tanks.get(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tanks.get(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tanks.get(tank).isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidStack resourceLeft = resource.copy();
        int totalFilled = 0;
        for (IFluidTank tank : this.tanks) {
            int filled = tank.fill(resourceLeft, action);
            resourceLeft.shrink(filled);
            totalFilled += filled;
            if (!resourceLeft.isEmpty()) continue;
            break;
        }
        return totalFilled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (IFluidTank tank : this.tanks) {
            if (tank.drain(resource, IFluidHandler.FluidAction.SIMULATE) == FluidStack.EMPTY) continue;
            return tank.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (IFluidTank tank : this.tanks) {
            if (tank.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE) == FluidStack.EMPTY) continue;
            return tank.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public Capability<IFluidHandler> getCapabilityType() {
        return ForgeCapabilities.FLUID_HANDLER;
    }

    @Override
    public LazyOptional<IFluidHandler> getCapability(@Nullable Direction side) {
        if (side == null) {
            if (!this.selfCache.isPresent()) {
                this.selfCache = LazyOptional.of(() -> this);
            }
            return this.selfCache.cast();
        }
        if (!this.config.getIOMode(side).canConnect()) {
            return LazyOptional.empty();
        }
        return this.sideCache.computeIfAbsent(side, dir -> LazyOptional.of(() -> new Sided(this, (Direction)dir))).cast();
    }

    @Override
    public void invalidateSide(@Nullable Direction side) {
        if (side != null) {
            if (this.sideCache.containsKey(side)) {
                this.sideCache.get(side).invalidate();
                this.sideCache.remove(side);
            }
        } else {
            this.selfCache.invalidate();
        }
    }

    @Override
    public void invalidateCaps() {
        for (LazyOptional<Sided> side : this.sideCache.values()) {
            side.invalidate();
        }
        this.selfCache.invalidate();
    }

    private static class Sided
    implements IFluidHandler {
        private final MachineFluidHandler master;
        private final Direction direction;

        Sided(MachineFluidHandler master, Direction direction) {
            this.master = master;
            this.direction = direction;
        }

        public int getTanks() {
            return this.master.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return this.master.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.master.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.master.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.master.getConfig().getIOMode(this.direction).canInput()) {
                return this.master.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.master.getConfig().getIOMode(this.direction).canOutput()) {
                return this.master.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.master.getConfig().getIOMode(this.direction).canOutput()) {
                return this.master.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

