/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import com.enderio.EnderIO;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineFluidTank
extends FluidTank {
    public boolean allowInput = true;
    public boolean allowOutput = true;
    @Nullable
    private final BlockEntity parent;

    public MachineFluidTank(int capacity, BlockEntity parent) {
        super(capacity, stack -> true);
        this.parent = parent;
    }

    public MachineFluidTank(BlockEntity parent) {
        super(8000, stack -> true);
        this.parent = parent;
    }

    public MachineFluidTank(int capacity, Predicate<FluidStack> validator, BlockEntity parent) {
        super(capacity, validator);
        this.parent = parent;
    }

    public int transferFrom(IFluidHandler from, int desiredAmount, boolean force) {
        FluidStack incomingStack = from.drain(desiredAmount, IFluidHandler.FluidAction.SIMULATE);
        int transferredAmount = this.fill(incomingStack, IFluidHandler.FluidAction.EXECUTE, force);
        from.drain(transferredAmount, IFluidHandler.FluidAction.EXECUTE);
        return transferredAmount;
    }

    public int transferTo(IFluidHandler to, int desiredAmount, boolean force) {
        FluidStack outStack = this.fluid.copy();
        int transferAmount = 0;
        if (!outStack.isEmpty()) {
            outStack.setAmount(this.drain(desiredAmount, IFluidHandler.FluidAction.SIMULATE, force));
            transferAmount = to.fill(outStack, IFluidHandler.FluidAction.EXECUTE);
        }
        this.drain(transferAmount, IFluidHandler.FluidAction.EXECUTE);
        return transferAmount;
    }

    public int fill(FluidStack source, IFluidHandler.FluidAction action, boolean force) {
        if (source.isEmpty()) {
            return 0;
        }
        if (!this.fluid.isEmpty() && !this.fluid.isFluidEqual(source)) {
            return 0;
        }
        if (!this.allowInput && !force) {
            return 0;
        }
        if (!this.isFluidValid(source) && !force) {
            return 0;
        }
        if (action.simulate()) {
            return Math.min(this.capacity - this.fluid.getAmount(), source.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = new FluidStack(source, Math.min(this.capacity, source.getAmount()));
            this.onContentsChanged();
            return this.fluid.getAmount();
        }
        int availableSpace = this.capacity - this.fluid.getAmount();
        int sourceAmount = source.getAmount();
        int transferAmount = Math.min(availableSpace, sourceAmount);
        this.fluid.grow(transferAmount);
        if (transferAmount > 0) {
            this.onContentsChanged();
        }
        return transferAmount;
    }

    public int fill(int desiredAmount, IFluidHandler.FluidAction action, boolean force) {
        if (this.fluid.isEmpty()) {
            EnderIO.LOGGER.error("No fluid in tank, can't contain an amount of unspecified fluid other than 0");
            return 0;
        }
        return this.fill(new FluidStack(this.fluid.getFluid(), desiredAmount), action, force);
    }

    public int fill(FluidStack source, IFluidHandler.FluidAction action) {
        return this.fill(source, action, false);
    }

    public int drain(int maxDrain, IFluidHandler.FluidAction action, boolean force) {
        if (maxDrain <= 0) {
            return 0;
        }
        if (!this.allowOutput && !force) {
            return 0;
        }
        int transferAmount = Math.min(maxDrain, this.fluid.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE && transferAmount > 0) {
            this.fluid.shrink(transferAmount);
            this.onContentsChanged();
        }
        return transferAmount;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Fluid storedFluid = this.fluid.getFluid();
        int amount = this.drain(maxDrain, action, false);
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(storedFluid, amount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult onClickedWithPotentialFluidItem(Player player, InteractionHand hand) {
        if (player.m_9236_().m_5776_() || !player.m_21033_(EquipmentSlot.MAINHAND) || hand != InteractionHand.MAIN_HAND) return InteractionResult.PASS;
        ItemStack heldStack = player.m_21205_();
        Optional heldItemFH = heldStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (heldStack.m_41720_() == Items.f_42446_ && this.allowOutput) {
            if (this.getFluidAmount() < 1000) return InteractionResult.PASS;
            FluidStack outStack = this.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            ItemStack filledBucket = new ItemStack((ItemLike)outStack.getFluid().m_6859_(), 1);
            if (heldStack.m_41613_() == 1) {
                player.m_21008_(hand, filledBucket);
                return InteractionResult.CONSUME;
            } else {
                heldStack.m_41774_(1);
                if (player.m_36356_(filledBucket)) return InteractionResult.CONSUME;
                player.m_36176_(filledBucket, true);
            }
            return InteractionResult.CONSUME;
        }
        Item outStack = heldStack.m_41720_();
        if (outStack instanceof BucketItem) {
            BucketItem filledBucket = (BucketItem)outStack;
            if (this.allowInput) {
                FluidStack bucketContent = new FluidStack(filledBucket.getFluid(), 1000);
                if (this.fill(bucketContent, IFluidHandler.FluidAction.SIMULATE) != 1000) return InteractionResult.PASS;
                this.fill(bucketContent, IFluidHandler.FluidAction.EXECUTE);
                player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_, 1));
                return InteractionResult.CONSUME;
            }
        }
        if (!heldItemFH.isPresent()) return InteractionResult.PASS;
        IFluidHandlerItem itemFluid = (IFluidHandlerItem)heldItemFH.get();
        boolean hasTransferred = false;
        if (this.allowOutput) {
            boolean bl = hasTransferred = this.transferTo((IFluidHandler)itemFluid, Integer.MAX_VALUE, false) > 0;
        }
        if (!this.allowInput || hasTransferred) return hasTransferred ? InteractionResult.CONSUME : InteractionResult.PASS;
        hasTransferred = this.transferFrom((IFluidHandler)itemFluid, Integer.MAX_VALUE, false) > 0;
        return hasTransferred ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    public void setFluid(FluidStack stack) {
        this.setFluid(stack, true);
    }

    public void setFluid(FluidStack stack, boolean force) {
        if (force || this.allowInput && this.isFluidValid(stack)) {
            this.fluid = stack;
            this.onContentsChanged();
        }
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.parent != null) {
            this.parent.m_6596_();
        }
    }
}

