/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.item;

import com.enderio.api.capability.IEnderCapabilityProvider;
import com.enderio.api.io.IIOConfig;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import java.util.EnumMap;
import java.util.function.IntConsumer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MachineInventory
extends ItemStackHandler
implements IEnderCapabilityProvider<IItemHandler> {
    private final IIOConfig config;
    private final MachineInventoryLayout layout;
    private final EnumMap<Direction, LazyOptional<Wrapped>> sideCache = new EnumMap(Direction.class);
    private LazyOptional<Wrapped> selfCache = LazyOptional.empty();
    private IntConsumer changeListener = i -> {};

    public MachineInventory(IIOConfig config, MachineInventoryLayout layout) {
        super(layout.getSlotCount());
        this.config = config;
        this.layout = layout;
    }

    public void addSlotChangedCallback(IntConsumer callback) {
        this.changeListener = this.changeListener.andThen(callback);
    }

    public final IIOConfig getConfig() {
        return this.config;
    }

    public final MachineInventoryLayout getLayout() {
        return this.layout;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.layout.isItemValid(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return this.layout.getStackLimit(slot);
    }

    @Override
    public Capability<IItemHandler> getCapabilityType() {
        return ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public LazyOptional<IItemHandler> getCapability(@Nullable Direction side) {
        if (side == null) {
            if (!this.selfCache.isPresent()) {
                this.selfCache = LazyOptional.of(() -> new Wrapped(this, null));
            }
            return this.selfCache.cast();
        }
        if (!this.config.getIOMode(side).canConnect()) {
            return LazyOptional.empty();
        }
        return this.sideCache.computeIfAbsent(side, dir -> LazyOptional.of(() -> new Wrapped(this, (Direction)dir))).cast();
    }

    @Override
    public void invalidateSide(@Nullable Direction side) {
        if (side != null) {
            if (this.sideCache.containsKey(side)) {
                this.sideCache.get(side).invalidate();
                this.sideCache.remove(side);
            }
        } else {
            this.selfCache.invalidate();
        }
    }

    @Override
    public void invalidateCaps() {
        for (LazyOptional<Wrapped> access : this.sideCache.values()) {
            access.invalidate();
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean wasEmpty = !simulate && this.getStackInSlot(slot).m_41619_();
        ItemStack itemStack = super.insertItem(slot, stack, simulate);
        if (wasEmpty && itemStack.m_41613_() != stack.m_41613_()) {
            this.changeListener.accept(slot);
        }
        return itemStack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack = super.extractItem(slot, amount, simulate);
        if (!itemStack.m_41619_() && !simulate && this.getStackInSlot(slot).m_41619_()) {
            this.changeListener.accept(slot);
        }
        return itemStack;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        boolean changed = stack.m_41720_() != this.getStackInSlot(slot).m_41720_();
        super.setStackInSlot(slot, stack);
        if (changed) {
            this.changeListener.accept(slot);
        }
    }

    public void updateMachineState(MachineState state, boolean add) {
    }

    private record Wrapped(MachineInventory master, @Nullable Direction side) implements IItemHandler
    {
        public int getSlots() {
            return this.master.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.master.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.master.getLayout().canInsert(slot)) {
                return stack;
            }
            if (this.side != null && !this.master.getConfig().getIOMode(this.side).canInput()) {
                return stack;
            }
            return this.master.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.master.getLayout().canExtract(slot)) {
                return ItemStack.f_41583_;
            }
            if (this.side != null && !this.master.getConfig().getIOMode(this.side).canOutput()) {
                return ItemStack.f_41583_;
            }
            return this.master.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.master.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.master.isItemValid(slot, stack);
        }
    }
}

