/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.item;

import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.item.AdvancedTooltipProvider;
import com.enderio.core.common.util.TooltipUtil;
import com.enderio.machines.client.rendering.item.FluidTankBEWLR;
import com.enderio.machines.common.block.MachineBlock;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankItem
extends BlockItem
implements AdvancedTooltipProvider {
    protected final int capacity;

    public FluidTankItem(MachineBlock block, Item.Properties properties, int capacity) {
        super((Block)block, properties);
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final Lazy<BlockEntityWithoutLevelRenderer> renderer = Lazy.of(() -> FluidTankBEWLR.INSTANCE);

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    @Override
    public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
            if (iFluidHandlerItem instanceof FluidItemStack) {
                FluidItemStack fluidHandler = (FluidItemStack)((Object)iFluidHandlerItem);
                if (fluidHandler.getFluid().isEmpty()) {
                    tooltips.add(TooltipUtil.style(EIOLang.TANK_EMPTY_STRING));
                } else {
                    tooltips.add(TooltipUtil.styledWithArgs(EIOLang.FLUID_TANK_TOOLTIP, fluidHandler.getFluid().getAmount(), this.capacity, fluidHandler.getFluid().getFluid().getFluidType().getDescription().getString()));
                }
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidItemStack(stack, this.capacity);
    }

    public class FluidItemStack
    extends FluidHandlerItemStack {
        public FluidItemStack(ItemStack container, int capacity) {
            super(container, capacity);
        }

        @NotNull
        public FluidStack getFluid() {
            Optional<CompoundTag> tagCompoundOptional = Optional.ofNullable(this.container.m_41783_());
            return tagCompoundOptional.map(tagCompound -> tagCompound.m_128469_("BlockEntityTag")).map(blockEntityTag -> blockEntityTag.m_128469_("Fluid")).map(FluidStack::loadFluidStackFromNBT).orElse(FluidStack.EMPTY);
        }

        protected void setFluid(FluidStack fluid) {
            CompoundTag mainTag = this.container.m_41784_();
            CompoundTag blockEntityTag = new CompoundTag();
            mainTag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
            CompoundTag fluidTag = new CompoundTag();
            fluid.writeToNBT(fluidTag);
            blockEntityTag.m_128365_("Fluid", (Tag)fluidTag);
        }

        protected void setContainerToEmpty() {
            CompoundTag blockEntityTag;
            CompoundTag tagCompound = this.container.m_41783_();
            if (tagCompound != null && (blockEntityTag = tagCompound.m_128469_("BlockEntityTag")).m_128441_("Fluid")) {
                blockEntityTag.m_128473_("Fluid");
            }
        }
    }
}

