/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.blockentity.PaintingMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PaintingRecipe
implements MachineRecipe<RecipeWrapper> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final Item output;

    public PaintingRecipe(ResourceLocation id, Ingredient input, Item output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(RecipeWrapper container, Level pLevel) {
        return this.input.test(PaintingMachineBlockEntity.INPUT.getItemStack((Container)container)) && !PaintingMachineBlockEntity.PAINT.getItemStack((Container)container).m_41619_();
    }

    @Override
    public int getBaseEnergyCost() {
        return (Integer)MachinesConfig.COMMON.ENERGY.PAINTING_MACHINE_ENERGY_COST.get();
    }

    @Override
    public List<OutputStack> craft(RecipeWrapper container, RegistryAccess registryAccess) {
        ArrayList<OutputStack> outputs = new ArrayList<OutputStack>();
        ItemStack outputStack = new ItemStack((ItemLike)this.output);
        CompoundTag tag = outputStack.m_41784_();
        CompoundTag beTag = new CompoundTag();
        tag.m_128365_("BlockEntityTag", (Tag)beTag);
        beTag.m_128359_("Paint", ForgeRegistries.ITEMS.getKey((Object)PaintingMachineBlockEntity.PAINT.getItemStack((Container)container).m_41720_()).toString());
        outputs.add(OutputStack.of(outputStack));
        return outputs;
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        return List.of(OutputStack.of(this.output.m_7968_()));
    }

    public ItemStack assemble(RecipeWrapper p_44001_, RegistryAccess p_267165_) {
        return null;
    }

    @Override
    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return new ItemStack((ItemLike)this.output);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.PAINTING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.PAINTING.type().get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public static class Serializer
    implements RecipeSerializer<PaintingRecipe> {
        public PaintingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)serializedRecipe.get("input").getAsJsonObject());
            ResourceLocation id = new ResourceLocation(serializedRecipe.get("output").getAsString());
            Item output = (Item)ForgeRegistries.ITEMS.getValue(id);
            return new PaintingRecipe(recipeId, input, output);
        }

        @Nullable
        public PaintingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                ResourceLocation outputId = buffer.m_130281_();
                Item output = (Item)ForgeRegistries.ITEMS.getValue(outputId);
                if (output == null) {
                    throw new ResourceLocationException("The output of recipe " + recipeId + " does not exist.");
                }
                return new PaintingRecipe(recipeId, input, output);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading painting recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, PaintingRecipe recipe) {
            try {
                recipe.input.m_43923_(buffer);
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)recipe.output)));
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing painting recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

