/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration;

import appeng.api.stacks.AEItemKey;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.me.common.GridInventoryEntry;
import java.util.Comparator;
import java.util.Map;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapelessTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.ITableRecipeAdapter;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.util.extendedcrafting.TableCraftingHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class ItemListTermCraftingHelper {
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::getStoredAmount);

    public static NonNullList<Ingredient> ensureNxNTableCraftingGrid(Recipe<?> recipe, int gridSize, int recipeWidth, int recipeHeight) {
        NonNullList ingredients = recipe.m_7527_();
        NonNullList expandedIngredients = NonNullList.m_122780_((int)gridSize, (Object)Ingredient.f_43901_);
        if (recipeWidth == -1 || recipeHeight == -1) {
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (ingredient.m_43947_()) continue;
                expandedIngredients.set(i, (Object)ingredient);
            }
        } else {
            int cursor = 0;
            TableCraftingHelper.GridCoordinate coordinator = TableCraftingHelper.indexToCoordinate(gridSize, recipeWidth, recipeHeight);
            for (int i = 0; i < expandedIngredients.size(); ++i) {
                if (!coordinator.test(i)) continue;
                expandedIngredients.set(i, (Object)((Ingredient)ingredients.get(cursor++)));
            }
        }
        return expandedIngredients;
    }

    public static NonNullList<ItemStack> findGoodTemplateItems(ITableRecipeAdapter recipe, ETTerminalBaseMenu<?> menu) {
        Map ingredientPriorities = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        NonNullList templateItems = NonNullList.m_122780_((int)menu.getCraftingGridSize(), (Object)ItemStack.f_41583_);
        NonNullList<Ingredient> ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            ItemStack stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt3157$temp = e.getKey();
                return patt3157$temp instanceof AEItemKey && (itemKey = (AEItemKey)patt3157$temp).matches(ingredient);
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.m_43908_()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }

    public static NonNullList<Ingredient> ensureFittedCraftingGrid(ITableRecipeAdapter recipe) {
        NonNullList<Ingredient> expandedIngredients;
        NonNullList ingredients = recipe.recipe().m_7527_();
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedTableRecipe = (IShapedTableRecipeAdapter)recipe;
            int width = shapedTableRecipe.width();
            int height = shapedTableRecipe.height();
            int matrixSize = width * height;
            NonNullList expandedIngredients2 = NonNullList.m_122780_((int)matrixSize, (Object)Ingredient.f_43901_);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int index = w + h * width;
                    if (index < ingredients.size()) {
                        expandedIngredients2.set(index, (Object)((Ingredient)ingredients.get(index)));
                        continue;
                    }
                    expandedIngredients2.set(index, (Object)Ingredient.f_43901_);
                }
            }
            return expandedIngredients2;
        }
        if (recipe instanceof IShapelessTableRecipeAdapter) {
            IShapelessTableRecipeAdapter shapelessTableRecipe = (IShapelessTableRecipeAdapter)recipe;
            expandedIngredients = TableCraftingHelper.makeNxNIngredients(shapelessTableRecipe);
            for (int i = 0; i < ingredients.size(); ++i) {
                expandedIngredients.set(i, (Object)((Ingredient)ingredients.get(i)));
            }
        } else {
            expandedIngredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        }
        return expandedIngredients;
    }
}

