/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ITerminalHost;
import appeng.helpers.IMenuCraftingPacket;
import appeng.menu.SlotSemantic;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.util.inv.PlayerInternalInventory;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.myogoo.extendedterminal.api.config.IETTerminalConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ETTerminalBaseMenu<R extends Recipe<?>>
extends MEStorageMenu
implements IMenuCraftingPacket {
    protected R currentRecipe;
    protected final ETMenuType menuType;
    private static final String ACTION_CLEAR_TO_PLAYER = "clearToPlayer";
    private final IETTerminalConfig config;

    public ETTerminalBaseMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, ETMenuType etMenuType, IETTerminalConfig config) {
        super(menuType, id, ip, host);
        this.menuType = etMenuType;
        this.config = config;
        this.registerClientAction(ACTION_CLEAR_TO_PLAYER, this::clearToPlayerInventory);
    }

    public R getCurrentRecipe() {
        return this.currentRecipe;
    }

    public abstract void clearCraftingGrid();

    public abstract SlotSemantic getCraftingGridSlotSemantic();

    public abstract SlotSemantic getOutputSlotSemantic();

    public abstract int getCraftingGridSize();

    public abstract int getCraftingGridWidth();

    public abstract int getCraftingGridHeight();

    protected abstract void updateCurrentRecipeAndOutput(boolean var1);

    public boolean useRealItems() {
        return true;
    }

    public boolean hasIngredient(Ingredient ingredient, Object2IntOpenHashMap<Object> reservedAmounts) {
        for (Slot slot : this.getSlots(this.getCraftingGridSlotSemantic())) {
            ItemStack stackInSlot = slot.m_7993_();
            if (stackInSlot.m_41619_() || !ingredient.test(stackInSlot)) continue;
            int reservedAmount = reservedAmounts.getOrDefault((Object)slot, 0);
            if (stackInSlot.m_41613_() <= reservedAmount) continue;
            reservedAmounts.merge((Object)slot, 1, Integer::sum);
            return true;
        }
        return super.hasIngredient(ingredient, reservedAmounts);
    }

    public void startAutoCrafting(List<IMenuCraftingPacket.AutoCraftEntry> toCraft) {
        CraftConfirmMenu.openWithCraftingList((IActionHost)this.getActionHost(), (ServerPlayer)((ServerPlayer)this.getPlayer()), (MenuLocator)this.getLocator(), toCraft);
    }

    public void m_6199_(@NonNull Container inventory) {
        this.updateCurrentRecipeAndOutput(false);
    }

    protected boolean isCraftable(ItemStack itemStack) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null) {
            for (GridInventoryEntry stack : clientRepo.getAllEntries()) {
                if (!AEItemKey.matches((AEKey)stack.getWhat(), (ItemStack)itemStack) || !stack.isCraftable()) continue;
                return true;
            }
        }
        return false;
    }

    public CraftingTermMenu.MissingIngredientSlots findMissingIngredients(Map<Integer, Ingredient> ingredients) {
        HashSet<Integer> missingSlots = new HashSet<Integer>();
        HashSet<Integer> craftableSlots = new HashSet<Integer>();
        Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
        NonNullList playerItems = this.getPlayerInventory().f_35974_;
        int[] reservedPlayerItems = new int[playerItems.size()];
        for (Map.Entry<Integer, Ingredient> entry : ingredients.entrySet()) {
            Ingredient ingredient = entry.getValue();
            boolean found = false;
            for (int i = 0; i < playerItems.size(); ++i) {
                ItemStack stack;
                if (this.isPlayerInventorySlotLocked(i) || (stack = (ItemStack)playerItems.get(i)).m_41613_() - reservedPlayerItems[i] <= 0 || !ingredient.test(stack)) continue;
                int n = i;
                reservedPlayerItems[n] = reservedPlayerItems[n] + 1;
                found = true;
                break;
            }
            if (!found && this.hasIngredient(ingredient, (Object2IntOpenHashMap<Object>)reservedGridAmounts)) {
                reservedGridAmounts.merge((Object)ingredient, 1, Integer::sum);
                found = true;
            }
            if (!found) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    if (!this.isCraftable(stack)) continue;
                    craftableSlots.add(entry.getKey());
                    found = true;
                    break;
                }
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        return new CraftingTermMenu.MissingIngredientSlots(missingSlots, craftableSlots);
    }

    public void clearToPlayerInventory() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR_TO_PLAYER);
            return;
        }
        InternalInventory craftingGridInv = this.getCraftingMatrix();
        PlayerInternalInventory playerInv = new PlayerInternalInventory(this.getPlayerInventory());
        for (int i = 0; i < craftingGridInv.size(); ++i) {
            for (int emptyLoop = 0; emptyLoop < 2; ++emptyLoop) {
                boolean allowEmpty = emptyLoop == 1;
                int HOTBAR_SIZE = 9;
                int j = 9;
                while (j-- > 0) {
                    if (playerInv.getStackInSlot(j).m_41619_() != allowEmpty) continue;
                    craftingGridInv.setItemDirect(i, playerInv.getSlotInv(j).addItems(craftingGridInv.getStackInSlot(i)));
                }
                for (j = 9; j < 36; ++j) {
                    if (playerInv.getStackInSlot(j).m_41619_() != allowEmpty) continue;
                    craftingGridInv.setItemDirect(i, playerInv.getSlotInv(j).addItems(craftingGridInv.getStackInSlot(i)));
                }
            }
        }
    }

    protected boolean checkCraftingOnlyActive() {
        return this.config.enableCraftOnlyPowered() && (this.getNetworkNode() == null || this.getNetworkNode() != null && !this.getNetworkNode().isActive());
    }

    public ETMenuType getETMenuType() {
        return this.menuType;
    }
}

