/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.slot;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.crafting.CraftingEvent;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.slot.AppEngCraftingSlot;
import appeng.util.Platform;
import appeng.util.inv.CarriedItemInventory;
import appeng.util.inv.PlayerInternalInventory;
import java.util.ArrayList;
import java.util.List;
import me.myogoo.extendedterminal.menu.ETMenuType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public abstract class ETCraftingBaseSlot<R extends Recipe<?>, I extends CraftingContainer>
extends AppEngCraftingSlot {
    protected final InternalInventory craftInv;
    private final InternalInventory pattern;
    protected final IActionSource mySrc;
    protected final IEnergySource energySrc;
    protected final IMenuCraftingPacket menu;
    private final MEStorage storage;
    protected final ETMenuType menuType;

    public ETCraftingBaseSlot(Player player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, IMenuCraftingPacket ccp, ETMenuType menuType) {
        super(player, cMatrix);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.menu = ccp;
        this.menuType = menuType;
    }

    protected abstract R findRecipe(I var1, Level var2);

    protected abstract ItemStack craftItem(Player var1, MEStorage var2, KeyCounter var3);

    public boolean m_8010_(Player player) {
        return false;
    }

    public void m_142406_(Player player, ItemStack is) {
    }

    public void doClick(InventoryAction action, Player who) {
        int maxTimesToCraft;
        PlayerInternalInventory target;
        if (this.m_7993_().m_41619_()) {
            return;
        }
        if (this.isRemote()) {
            return;
        }
        int howManyPerCraft = this.m_7993_().m_41613_();
        if (action == InventoryAction.CRAFT_SHIFT || action == InventoryAction.CRAFT_ALL) {
            target = new PlayerInternalInventory(who.m_150109_());
            maxTimesToCraft = action == InventoryAction.CRAFT_SHIFT ? (int)Math.floor((double)this.m_7993_().m_41741_() / (double)howManyPerCraft) : (int)Math.floor((double)this.m_7993_().m_41741_() / (double)howManyPerCraft * 36.0);
        } else if (action == InventoryAction.CRAFT_STACK) {
            target = new CarriedItemInventory((AbstractContainerMenu)this.getMenu());
            maxTimesToCraft = (int)Math.floor((double)this.m_7993_().m_41741_() / (double)howManyPerCraft);
        } else {
            if (this.getMenu().m_142621_().m_41619_()) {
                this.getMenu().m_142503_(this.craftItem(who, this.storage, this.storage.getAvailableStacks()));
                return;
            }
            target = new CarriedItemInventory((AbstractContainerMenu)this.getMenu());
            maxTimesToCraft = 1;
        }
        ItemStack itemAtStart = this.m_7993_().m_41777_();
        if (itemAtStart.m_41619_()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            if (!ItemStack.m_150942_((ItemStack)itemAtStart, (ItemStack)this.m_7993_())) {
                return;
            }
            if (!target.simulateAdd(itemAtStart).m_41619_()) {
                return;
            }
            KeyCounter all = this.storage.getAvailableStacks();
            ItemStack extra = target.addItems(this.craftItem(who, this.storage, all));
            if (extra.m_41619_()) continue;
            Platform.spawnDrops((Level)who.m_9236_(), (BlockPos)who.m_20183_(), List.of(extra));
            return;
        }
    }

    protected void postCraft(Player p, MEStorage inv, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!p.m_20193_().m_5776_()) {
            for (int x = 0; x < this.craftInv.size(); ++x) {
                int amount;
                AEItemKey what;
                long inserted;
                if (this.craftInv.getStackInSlot(x).m_41619_()) {
                    this.craftInv.setItemDirect(x, set[x]);
                    continue;
                }
                if (set[x].m_41619_() || (inserted = inv.insert((AEKey)(what = AEItemKey.of((ItemStack)set[x])), (long)(amount = set[x].m_41613_()), Actionable.MODULATE, this.mySrc)) >= (long)amount) continue;
                drops.add(what.toStack((int)((long)amount - inserted)));
            }
        }
        if (!drops.isEmpty()) {
            Platform.spawnDrops((Level)p.m_9236_(), (BlockPos)new BlockPos((int)p.m_20185_(), (int)p.m_20186_(), (int)p.m_20189_()), drops);
        }
    }

    protected void makeItem(Player player, ItemStack stack) {
        CraftingEvent.fireCraftingEvent((Player)player, (ItemStack)stack, (Container)this.craftInv.toContainer());
        this.m_5845_(stack);
        NonNullList items = NonNullList.m_122780_((int)this.craftInv.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.craftInv.size(); ++i) {
            items.set(i, (Object)this.craftInv.getStackInSlot(i));
        }
        TransientCraftingContainer positioned = new TransientCraftingContainer((AbstractContainerMenu)this.getMenu(), this.menuType.getGridSideLength(), this.menuType.getGridSideLength(), items);
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList remainingItems = this.getRemainingItems((CraftingContainer)positioned, player.m_9236_());
        ForgeHooks.setCraftingPlayer(null);
        for (int y = 0; y < this.menuType.getGridSideLength(); ++y) {
            for (int x = 0; x < this.menuType.getGridSideLength(); ++x) {
                ItemStack remainingInSlot;
                int slotIdx = y * this.menuType.getGridSideLength() + x;
                int remainderIdx = y * this.menuType.getGridSideLength() + x;
                this.craftInv.extractItem(slotIdx, 1, false);
                if (remainderIdx < 0 || remainderIdx >= remainingItems.size() || (remainingInSlot = (ItemStack)remainingItems.get(remainderIdx)).m_41619_()) continue;
                if (this.craftInv.getStackInSlot(slotIdx).m_41619_()) {
                    this.craftInv.setItemDirect(slotIdx, remainingInSlot);
                    continue;
                }
                if (player.m_150109_().m_36054_(remainingInSlot)) continue;
                player.m_36176_(remainingInSlot, false);
            }
        }
    }

    protected InternalInventory getPattern() {
        return this.pattern;
    }
}

