/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl;

import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class BookBinder {
    private final ResourceLocation registryName;
    private Consumer<List<CategoryAbstract>> contentProvider;
    @Nonnull
    private Component guideTitle = Component.m_237115_((String)"item.guideapi.book");
    @Nullable
    private Component header;
    @Nullable
    private Component itemName;
    @Nullable
    private Component author;
    private ResourceLocation pageTexture = new ResourceLocation("guideapi_vp", "textures/gui/book_colored.png");
    private ResourceLocation outlineTexture = new ResourceLocation("guideapi_vp", "textures/gui/book_greyscale.png");
    private Color color = new Color(171, 70, 30);
    private boolean spawnWithBook;

    public BookBinder(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public Book build() {
        if (this.author == null) {
            this.author = Component.m_237113_((String)ModList.get().getModContainerById(this.registryName.m_135827_()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse("Unknown"));
        }
        if (this.header == null) {
            this.header = this.guideTitle;
        }
        if (this.itemName == null) {
            this.itemName = this.guideTitle;
        }
        if (this.contentProvider == null) {
            throw new IllegalStateException("Content supplier of book " + this.registryName.toString() + " must be provided");
        }
        return new Book(this.contentProvider, this.guideTitle, this.header, this.itemName, this.author, this.pageTexture, this.outlineTexture, this.color, this.spawnWithBook, this.registryName);
    }

    public BookBinder setAuthor(Component author) {
        this.author = author;
        return this;
    }

    public BookBinder setColor(Color color) {
        this.color = color;
        return this;
    }

    public BookBinder setColor(int color) {
        return this.setColor(new Color(color));
    }

    public BookBinder setContentProvider(Consumer<List<CategoryAbstract>> contentProvider) {
        this.contentProvider = contentProvider;
        return this;
    }

    public BookBinder setGuideTitle(Component guideTitle) {
        this.guideTitle = guideTitle;
        return this;
    }

    public BookBinder setGuideTitleKey(String translationKey) {
        return this.setGuideTitle((Component)Component.m_237115_((String)translationKey));
    }

    public BookBinder setHeader(Component header) {
        this.header = header;
        return this;
    }

    public BookBinder setHeaderKey(String translationKey) {
        return this.setHeader((Component)Component.m_237115_((String)translationKey));
    }

    public BookBinder setItemName(Component itemName) {
        this.itemName = itemName;
        return this;
    }

    public BookBinder setItemNameKey(String translationKey) {
        return this.setItemName((Component)Component.m_237115_((String)translationKey));
    }

    public BookBinder setOutlineTexture(ResourceLocation outlineTexture) {
        this.outlineTexture = outlineTexture;
        return this;
    }

    public BookBinder setPageTexture(ResourceLocation pageTexture) {
        this.pageTexture = pageTexture;
        return this;
    }

    public BookBinder setSpawnWithBook() {
        this.spawnWithBook = true;
        return this;
    }
}

