/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import de.maxanier.guideapi.GuideMod;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.gui.BaseScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.glfw.GLFW;

public class SearchScreen
extends BaseScreen {
    private final Book book;
    private final ResourceLocation outlineTexture;
    private final ResourceLocation pageTexture;
    private final int renderXOffset = 37;
    private final int renderYOffset = 30;
    private final Screen parent;
    private ButtonNext buttonNext;
    private ButtonPrev buttonPrev;
    private EditBox searchField;
    private List<List<Pair<EntryAbstract, CategoryAbstract>>> searchResults;
    private int currentPage = 0;
    private String lastQuery = "";

    @Nonnull
    static List<List<Pair<EntryAbstract, CategoryAbstract>>> getMatches(Book book, @Nullable String query, Player player, ItemStack bookStack) {
        ArrayList discovered = Lists.newArrayList();
        for (CategoryAbstract category : book.getCategoryList()) {
            if (!category.canSee(player, bookStack)) continue;
            for (EntryAbstract entry : category.entries.values()) {
                if (!entry.canSee(player, bookStack) || !Strings.isNullOrEmpty((String)query) && !entry.getName().getString().toLowerCase(Locale.ENGLISH).contains(query.toLowerCase(Locale.ENGLISH))) continue;
                discovered.add(Pair.of((Object)entry, (Object)category));
            }
        }
        return Lists.partition((List)discovered, (int)10);
    }

    public SearchScreen(Book book, Player player, ItemStack bookStack, Screen parent) {
        super(book.getTitle(), player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.parent = parent;
        this.searchResults = SearchScreen.getMatches(book, null, player, bookStack);
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public void m_7856_() {
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.f_96541_.m_91152_(this.parent), this));
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.currentPage <= this.searchResults.size() - 1) {
                ++this.currentPage;
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonPrev);
        this.searchField = new EditBox(this.f_96547_, this.guiLeft + 43, this.guiTop + 12, 100, 10, (Component)Component.m_237115_((String)"guideapi.button.search"));
        this.searchField.m_94182_(false);
        this.searchField.m_93692_(true);
        this.searchResults = SearchScreen.getMatches(this.book, null, this.player, this.bookStack);
    }

    @Override
    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.searchField.m_93696_()) {
            return super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        }
        if (keyCode == 256) {
            this.searchField.m_93692_(false);
        }
        if (this.searchField.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int typeofClick) {
        if (!super.m_6375_(mouseX, mouseY, typeofClick)) {
            if (typeofClick == 0) {
                int entryX = this.guiLeft + 37;
                int entryY = this.guiTop + 30;
                if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
                    List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
                    for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                        if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10)) {
                            GuideMod.PROXY.openEntry(this.book, (CategoryAbstract)entry.getRight(), (EntryAbstract)entry.getLeft(), this.player, this.bookStack);
                        }
                        entryY += 13;
                    }
                }
            } else if (typeofClick == 1) {
                if (GuiHelper.isMouseBetween(mouseX, mouseY, this.searchField.m_252754_(), this.searchField.m_252907_(), this.searchField.m_94210_(), this.searchField.m_93694_())) {
                    this.searchField.m_94144_("");
                    this.lastQuery = "";
                    this.searchResults = SearchScreen.getMatches(this.book, "", this.player, this.bookStack);
                    return true;
                }
                this.f_96541_.m_91152_(this.parent);
                return true;
            }
            return this.searchField.m_6375_(mouseX, mouseY, typeofClick);
        }
        return true;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0 && this.buttonNext.f_93624_ && this.currentPage <= this.searchResults.size()) {
            ++this.currentPage;
        } else if (movement > 0.0 && this.buttonPrev.f_93624_ && this.currentPage > 0) {
            --this.currentPage;
        }
        return movement != 0.0 || super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.m_280218_(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280509_(this.searchField.m_252754_() - 1, this.searchField.m_252907_() - 1, this.searchField.m_252754_() + this.searchField.m_94210_() + 1, this.searchField.m_252907_() + this.searchField.m_93694_() + 1, new Color(166, 166, 166, 128).getRGB());
        graphics.m_280509_(this.searchField.m_252754_(), this.searchField.m_252907_(), this.searchField.m_252754_() + this.searchField.m_94210_(), this.searchField.m_252907_() + this.searchField.m_93694_(), new Color(58, 58, 58, 128).getRGB());
        this.searchField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int entryX = this.guiLeft + 37;
        int entryY = this.guiTop + 30;
        if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
            List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
            for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                ((EntryAbstract)entry.getLeft()).draw(graphics, Minecraft.m_91087_().f_91073_.m_9598_(), this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.f_96547_);
                ((EntryAbstract)entry.getLeft()).drawExtras(graphics, this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.f_96547_);
                if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10) && GLFW.glfwGetKey((long)this.f_96541_.m_91268_().m_85439_(), (int)340) == 1) {
                    graphics.m_280677_(this.f_96547_, ((CategoryAbstract)entry.getRight()).getTooltip(), Optional.empty(), mouseX, mouseY);
                }
                entryY += 13;
            }
        }
        this.buttonPrev.f_93624_ = this.currentPage != 0;
        this.buttonNext.f_93624_ = this.currentPage != this.searchResults.size() - 1 && !this.searchResults.isEmpty();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void updateSearch() {
        if (!this.searchField.m_94155_().equalsIgnoreCase(this.lastQuery)) {
            this.lastQuery = this.searchField.m_94155_();
            this.searchResults = SearchScreen.getMatches(this.book, this.searchField.m_94155_(), this.player, this.bookStack);
            if (this.currentPage > this.searchResults.size()) {
                this.currentPage = this.searchResults.size() - 1;
            }
        }
    }
}

