/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.actions;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.zeith.hammerlib.abstractions.actions.ILevelActionType;
import org.zeith.hammerlib.core.RegistriesHL;

public abstract class LevelAction {
    protected final ILevelActionType type;

    public LevelAction(ILevelActionType type) {
        this.type = type;
    }

    public abstract CompoundTag write(Level var1);

    public final ILevelActionType getType() {
        return this.type;
    }

    public static CompoundTag write(Level level, LevelAction action) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Data", (Tag)action.write(level));
        tag.m_128359_("Type", action.getType().getRegistryKey().toString());
        return tag;
    }

    public static Optional<LevelAction> read(Level level, @Nullable CompoundTag tag) {
        if (tag == null) {
            return Optional.empty();
        }
        ILevelActionType type = (ILevelActionType)RegistriesHL.levelActions().getValue(new ResourceLocation(tag.m_128461_("Type")));
        if (type == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.read(level, tag.m_128469_("Data")));
    }
}

