/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.items.IColoredFoilItem;
import org.zeith.hammerlib.core.init.ItemsHL;
import org.zeith.hammerlib.core.test.machine.BlockTestMachine;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.IOUtils;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.shaded.json.JSONException;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomFoilConfigs {
    private static final List<Tuple2<Item, IColoredFoilItem>> overrides = new ArrayList<Tuple2<Item, IColoredFoilItem>>();
    public static boolean disable_with_rubidium = true;
    public static Runnable rubidiumInstaller = null;

    @SubscribeEvent
    public static void enqueueInterComms(InterModEnqueueEvent e) {
        InterModComms.sendTo((String)"hammerlib", (String)"registerFoil", () -> Map.entry(ItemsHL.WRENCH, -241));
        InterModComms.sendTo((String)"hammerlib", (String)"registerFoil", () -> Map.entry(BlockTestMachine.TEST_MACHINE, stack -> -15790081));
    }

    @SubscribeEvent
    public static void handleInterComms(InterModProcessEvent evt) {
        evt.getIMCStream("registerFoil"::equals).forEach(msg -> {
            Item theItem;
            ItemLike item = null;
            Object obj = msg.messageSupplier().get();
            if (obj instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)obj;
                item = Cast.cast(e.getKey(), ItemLike.class);
                obj = e.getValue();
            }
            IColoredFoilItem foil = null;
            Object provider = "";
            if (obj instanceof Integer) {
                Integer constant = (Integer)obj;
                foil = IColoredFoilItem.constant(constant);
                provider = "constant(0x" + Integer.toHexString(constant).toUpperCase(Locale.ROOT) + ")";
            } else if (obj instanceof ToIntFunction) {
                ToIntFunction fun;
                ToIntFunction stack = fun = (ToIntFunction)obj;
                foil = stack::applyAsInt;
                provider = "dynamic(" + fun + ")";
            }
            if (item == null || (theItem = item.m_5456_()) == null) {
                HammerLib.LOG.warn("{} sent a {} IMC message, but the item can not be determined. Must be ItemLike that returns non-null item.", (Object)msg.senderModId(), (Object)msg.method());
                return;
            }
            if (foil == null) {
                HammerLib.LOG.warn("{} sent a {} IMC message, but the foil can not be determined. Must be either Integer, or ToIntFunction<ItemStack>.", (Object)msg.senderModId(), (Object)msg.method());
                return;
            }
            IColoredFoilItem.override(theItem, foil);
            HammerLib.LOG.info("Performed {} from {}. Determined {} foil provider", (Object)msg.method(), (Object)msg.senderModId(), provider);
        });
    }

    public static void reload() throws ReportedException {
        for (Tuple2<Item, IColoredFoilItem> tup : overrides) {
            tup.accept(IColoredFoilItem::removeOverride);
        }
        overrides.clear();
        try {
            JSONObject $;
            Path path = FMLPaths.CONFIGDIR.get().resolve("hammerlib").resolve("foil_colors.json");
            if (Files.isDirectory(path, new LinkOption[0])) {
                IOUtils.deleteFolder(path);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                $ = new JSONObject();
                $.put("disable_with_rubidium", true);
                $.put("constant_colors", new JSONObject().put(Objects.toString(ForgeRegistries.ITEMS.getKey((Object)Items.f_42686_)), -59299).put(Objects.toString(ForgeRegistries.ITEMS.getKey((Object)Items.f_42437_)), -131178));
                Files.writeString(path, (CharSequence)$.toString(2), new OpenOption[0]);
            }
            if (!($ = new JSONTokener(Files.readString(path)).nextValueOBJ().orElseThrow()).has("disable_with_rubidium")) {
                $.put("disable_with_rubidium", true);
                Files.writeString(path, (CharSequence)$.toString(2), new OpenOption[0]);
            }
            disable_with_rubidium = $.optBoolean("disable_with_rubidium");
            JSONObject constant_colors = $.getJSONObject("constant_colors");
            for (String s : constant_colors.keySet()) {
                ResourceLocation loc = ResourceLocation.m_135820_((String)s);
                if (loc == null) {
                    HammerLib.LOG.info("foil_colors.json/constant_colors: Unable to parse {} as a valid resource path. Skipping.", (Object)JSONObject.quote(s));
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
                if (item == null || item == Items.f_41852_) {
                    HammerLib.LOG.info("foil_colors.json/constant_colors: Unable to find item " + loc + ". Skipping.");
                    continue;
                }
                IColoredFoilItem foil = IColoredFoilItem.constant(constant_colors.getInt(s));
                overrides.add(Tuples.immutable(item, foil));
                IColoredFoilItem.override(item, foil);
            }
            if (rubidiumInstaller != null) {
                rubidiumInstaller.run();
            }
        }
        catch (IOException | JSONException e) {
            throw new ReportedException(new CrashReport("", (Throwable)e));
        }
    }
}

