/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.reader;

import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.abstractions.props.Key;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.data.FlowQuery;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.client.flowgui.reader.JsContext;
import org.zeith.hammerlib.client.flowgui.reader.RootReader;
import org.zeith.hammerlib.core.js.JsFactory;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.data.XmlHelper;
import org.zeith.hammerlib.util.data.XmlNode;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.Hashers;
import org.zeith.hammerlib.util.java.itf.FloatSupplier;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@OnlyIn(value=Dist.CLIENT)
public class FlowguiRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowguiRegistry.class);
    public static final FileToIdConverter FILE_TO_ID_CONVERTER = new FileToIdConverter("flowgui", ".xml");
    private static final Map<ResourceLocation, GuiReader<?>> REGISTRY = new HashMap();
    private static ResourceManager resources;
    private static final Map<Type, ResourceLocation> PRELOADED;
    private static final Set<ResourceLocation> MISSING;
    private static final Map<ResourceLocation, Supplier<IDataNode>> GUI_DATA;
    public static final Key<FlowQuery> QUERY;
    public static final Key<ResourceLocation> ROOT_ID;
    public static final Key<GuiRootObject> PREVIOUS_ROOT;
    public static final Key<Boolean> IS_CACHING_JS;
    public static final Key<GuiRootObject> GUI_ROOT;
    public static final Key<Stack<ResourceLocation>> LOAD_STACK;
    public static final Key<JsContext> JS_CONTEXT;
    public static final Key<RandomSource> NAMEGEN_RANDOM;
    public static boolean DISABLE_CACHE;
    private static final JsContext GLOBAL;

    @NotNull
    public static GuiRootObject readRoot(KeyMap context) {
        ResourceLocation location = context.opt(ROOT_ID).orElseThrow();
        Screen gui = context.opt(FlowguiRegistry.QUERY).orElseThrow().gui;
        context.put(LOAD_STACK, new Stack());
        context.put(JS_CONTEXT, GLOBAL);
        context.computeIfAbsent(IS_CACHING_JS, Cast.constant(false));
        context.put(NAMEGEN_RANDOM, RandomSource.m_216335_((long)Hashers.hashCodeL(location.m_135827_(), location.m_135815_())));
        GuiRootObject root = FlowguiRegistry.readRoot(location, context, gui != null ? () -> gui.f_96543_ : Cast.constantF(1920.0f), gui != null ? () -> gui.f_96544_ : Cast.constantF(1080.0f));
        root.finishBuilding();
        return root;
    }

    @NotNull
    public static GuiRootObject readRoot(ResourceLocation location, KeyMap context, FloatSupplier parentWidth, FloatSupplier parentHeight) {
        Stack<ResourceLocation> stack = context.get(LOAD_STACK);
        if (stack.contains(location)) {
            log.error("Detected infinite recursion while loading Flowgui root. Load stack: {} -X-> {}", (Object)stack.stream().map(ResourceLocation::toString).collect(Collectors.joining(" -> ")), (Object)location);
            return GuiObject.root();
        }
        stack.push(location);
        GuiRootObject root = FlowguiRegistry.readRootUnsafe(location, context, parentWidth, parentHeight);
        stack.pop();
        if (root == null) {
            return GuiObject.root();
        }
        return root;
    }

    @Nullable
    private static GuiRootObject readRootUnsafe(ResourceLocation location, KeyMap context, FloatSupplier parentWidth, FloatSupplier parentHeight) {
        Supplier<IDataNode> dataProvider = FlowguiRegistry.getFlowguiFile(location);
        if (dataProvider == null) {
            if (MISSING.add(location)) {
                log.error("Unknown flowgui file: {}", (Object)FILE_TO_ID_CONVERTER.m_245698_(location));
            }
            return null;
        }
        IDataNode data = dataProvider.get();
        if (data == null) {
            if (MISSING.add(location)) {
                log.error("Missing flowgui file: {}", (Object)FILE_TO_ID_CONVERTER.m_245698_(location));
            }
            return null;
        }
        try {
            return Objects.requireNonNull((GuiRootObject)RootReader.INSTANCE.read(context, data, parentWidth, parentHeight), "The root was not created.");
        }
        catch (Exception e) {
            log.error("Failed to create Flowgui instance from file {}", (Object)FILE_TO_ID_CONVERTER.m_245698_(location), (Object)e);
            return null;
        }
    }

    @Nullable
    static Optional<GuiObject> read(KeyMap context, IDataNode data, FloatSupplier parentWidth, FloatSupplier parentHeight) {
        String cls = data.getString("class");
        GuiReader<?> reader = FlowguiRegistry.getReader(Resources.locationOrNull(cls.toLowerCase(Locale.ROOT)));
        if (reader == null) {
            log.error("{} flowgui class: {}", (Object)(Resources.locationOrNull(cls.toLowerCase(Locale.ROOT)) == null ? "Malformed" : "Unknown"), (Object)cls);
            return null;
        }
        return Optional.ofNullable(reader.read(context, data, parentWidth, parentHeight));
    }

    static GuiReader<?> getReader(ResourceLocation id) {
        return id != null ? REGISTRY.get(id) : null;
    }

    public static void reload(ResourceManager resources, ProfilerFiller profiler) {
        FlowguiRegistry.resources = resources;
        GUI_DATA.clear();
        MISSING.clear();
        GLOBAL.clear();
        JsFactory.init(true);
        for (ResourceLocation id : PRELOADED.values()) {
            FlowguiRegistry.getFlowguiFile(id);
            if (DISABLE_CACHE) continue;
            FlowguiRegistry.readRoot(KeyMap.createHash().with(QUERY, new FlowQuery(null)).with(ROOT_ID, id).with(IS_CACHING_JS, true));
        }
    }

    static Supplier<IDataNode> getFlowguiFile(ResourceLocation id) {
        Supplier<IDataNode> reg = GUI_DATA.get(id);
        if (reg != null) {
            return reg;
        }
        ResourceLocation file = FILE_TO_ID_CONVERTER.m_245698_(id);
        com.google.common.base.Supplier provider = () -> {
            Resource res = resources.m_213713_(file).orElse(null);
            if (res == null) {
                log.error("Flowgui XML file not found: {}", (Object)file);
                return null;
            }
            try (InputStream input = res.m_215507_();){
                XmlNode data = XmlHelper.parse(new String(input.readAllBytes(), StandardCharsets.UTF_8));
                if (data == null) {
                    log.error("Unable to read XML from flowgui file: {}", (Object)file);
                    IDataNode iDataNode = null;
                    return iDataNode;
                }
                if (!data.getMyName().equalsIgnoreCase("root")) {
                    log.error("Malformed XML from flowgui file {}: First XML node must always be <root>", (Object)file);
                    IDataNode iDataNode = null;
                    return iDataNode;
                }
                XmlNode xmlNode = data;
                return xmlNode;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.error("Failed to load flowgui file: {}", (Object)file, (Object)e);
                return null;
            }
        };
        if (!DISABLE_CACHE) {
            provider = Suppliers.memoize(() -> provider.get());
        }
        GUI_DATA.put(id, (Supplier<IDataNode>)provider);
        return provider;
    }

    public static ResourceLocation getId(Class<? extends Screen> gui) {
        return Objects.requireNonNull(PRELOADED.get(Type.getType(gui)), "XmlFlowgui.value() on " + gui);
    }

    public static void handleXml(ScanDataHelper.ModAwareAnnotationData data) {
        PRELOADED.put(data.clazz(), Resources.location(data.getOwnerMod().orElseThrow().getNamespace(), Objects.toString(data.getProperty("value").orElseThrow())));
    }

    public static void handleReader(ScanDataHelper.ModAwareAnnotationData data) {
        try {
            Constructor<GuiReader> ctor = data.getOwnerClass().asSubclass(GuiReader.class).getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            GuiReader reader = ctor.newInstance(new Object[0]);
            ResourceLocation id = Resources.location(data.getOwnerMod().orElseThrow().getNamespace(), Objects.toString(data.getProperty("value").orElseThrow()));
            REGISTRY.put(id, reader);
        }
        catch (Exception e) {
            HammerLib.LOG.error("Failed to create FlowguiReader: {}", (Object)data.clazz());
        }
    }

    static {
        PRELOADED = new HashMap<Type, ResourceLocation>();
        MISSING = new HashSet<ResourceLocation>();
        GUI_DATA = new HashMap<ResourceLocation, Supplier<IDataNode>>();
        QUERY = Key.of(HLConstants.id("query"), FlowQuery.class);
        ROOT_ID = Key.of(HLConstants.id("root_id"), ResourceLocation.class);
        PREVIOUS_ROOT = Key.of(HLConstants.id("previous_root"), GuiRootObject.class);
        IS_CACHING_JS = Key.of(HLConstants.id("caching_js"), Boolean.class);
        GUI_ROOT = Key.of(HLConstants.id("gui_root"), GuiRootObject.class);
        LOAD_STACK = Key.of(HLConstants.id("load_stack"), (Class)Cast.cast(Stack.class));
        JS_CONTEXT = Key.of(HLConstants.id("js_context"), JsContext.class);
        NAMEGEN_RANDOM = Key.of(HLConstants.id("namegen_random"), RandomSource.class);
        DISABLE_CACHE = Boolean.parseBoolean(Objects.toString(System.getProperty("hammerlib.flowgui.nocache")));
        GLOBAL = new JsContext();
    }
}

