/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.FileReference;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.annotations.ide.Suggestions;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.objects.GuiItemObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.util.mcf.Resources;

@Namespace(value="hammerlib")
@FlowguiReader(value="item")
public class FlowguiItemReader
extends GuiReader<GuiItemObject> {
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @FileReference(regex={"^(?<modid>[a-z0-9_.-]+):(?<path>[a-z0-9_./-]+)$", "^(?<path>[a-z0-9_./-]+)$"}, value={"assets/%modid%/models/item/%path%.json", "assets/minecraft/models/item/%path%.json"})
    @Required(value="minecraft:diamond")
    public static final String KEY_ITEM = "item";
    @AllowJS
    @AllowedValues(value={"^0*[1-9]\\d*$"})
    public static final String KEY_COUNT = "count";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_HOVERABLE = "hoverable";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_DECORATED = "decorated";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    public static final String KEY_OFFER_INGREDIENT = "offer-ingredient";
    @AllowJS
    public static final String KEY_NBT = "nbt";

    @Override
    protected GuiItemObject readObject(KeyMap map, String name, IDataNode node) {
        AtomicReference<GuiItemObject> self = new AtomicReference<GuiItemObject>();
        DriverContext ctx = this.getDriverContext(map, node, self);
        java.util.function.Supplier<String> itemIdFactory = ComDrivers.readString(ctx, KEY_ITEM);
        java.util.function.Supplier<String> tagFactory = ComDrivers.readString(ctx, KEY_NBT);
        boolean constant = ComDrivers.isConstant(itemIdFactory) && ComDrivers.isConstant(tagFactory);
        Supplier primaryFactory = () -> {
            ItemStack stack = ((Item)BuiltInRegistries.f_257033_.m_7745_(Resources.location((String)itemIdFactory.get()))).m_7968_();
            String tag = (String)tagFactory.get();
            if (tag != null && !tag.isBlank()) {
                try {
                    stack.m_41751_(TagParser.m_129359_((String)tag));
                }
                catch (CommandSyntaxException e) {
                    stack.m_41714_((Component)Component.m_237113_((String)e.toString()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                }
            }
            return stack;
        };
        Supplier intermFactory = constant ? Suppliers.memoize(() -> primaryFactory.get()) : primaryFactory;
        AtomicInteger count = new AtomicInteger(1);
        java.util.function.Supplier<ItemStack> finalFactory = () -> FlowguiItemReader.lambda$readObject$1((java.util.function.Supplier)intermFactory, count);
        GuiItemObject o = new GuiItemObject(name, finalFactory);
        self.set(o);
        ComDrivers.driveInt(ctx, KEY_COUNT, 1, false, count::set);
        ComDrivers.driveBool(ctx, KEY_HOVERABLE, false, false, o::hoverable);
        ComDrivers.driveBool(ctx, KEY_DECORATED, true, false, o::decorated);
        ComDrivers.driveBool(ctx, KEY_OFFER_INGREDIENT, false, false, o::provideIngredient);
        return o;
    }

    private static /* synthetic */ ItemStack lambda$readObject$1(java.util.function.Supplier intermFactory, AtomicInteger count) {
        ItemStack stack = (ItemStack)intermFactory.get();
        stack.m_41764_(count.get());
        return stack;
    }
}

