/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.items.IIngredientProvider;
import org.zeith.hammerlib.core.adapter.OreDictionaryAdapter;
import org.zeith.hammerlib.core.recipes.ServerContext;
import org.zeith.hammerlib.event.ParseIngredientEvent;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.java.Cast;

public class RecipeHelper {
    public static final String NEOFORGE_MOD_ID_FOR_TAGS = "forge";

    public static void registerCustomRecipes(Predicate<ResourceLocation> idInUse, Consumer<Recipe<?>> addRecipe, Consumer<Set<ResourceLocation>> removeRecipes, boolean silent, ServerContext context) {
        RegisterRecipesEvent rre = new RegisterRecipesEvent(idInUse, context);
        ModList.get().forEachModInOrder(mc -> {
            if (!(mc instanceof FMLModContainer)) {
                return;
            }
            FMLModContainer fmc = (FMLModContainer)mc;
            rre.setContextModId(mc.getModId());
            fmc.getEventBus().post((Event)rre);
        });
        rre.setContextModId(null);
        rre.cleanup();
        if (!silent) {
            HLConstants.LOG.info("Reloading HammerLib recipes...");
        }
        AtomicLong count = new AtomicLong();
        rre.getRecipes().forEach(recipe -> {
            addRecipe.accept((Recipe<?>)recipe);
            count.incrementAndGet();
        });
        removeRecipes.accept(rre.removedRecipes());
        if (!silent) {
            HLConstants.LOG.info("HammerLib injected {} recipes into recipe map. Removed {} recipes from the game.", (Object)count.longValue(), (Object)rre.removedRecipes().size());
        }
    }

    public static void injectRecipes(RecipeManager mgr, ICondition.IContext context) {
        Internal.mutableManager(mgr);
        ArrayList recipeList = new ArrayList();
        HashSet removed = new HashSet();
        RecipeHelper.registerCustomRecipes(id -> mgr.m_44043_(id).isPresent(), recipeList::add, removed::addAll, false, ServerContext.gather(mgr, context));
        Internal.addRecipes(mgr, recipeList);
        Internal.removeRecipes(mgr, removed::stream);
    }

    public static <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> getRecipeMap(Level level, RecipeType<T> type) {
        return level.m_7465_().m_44054_(type);
    }

    public static <C extends Container, T extends Recipe<C>> Stream<T> getRecipes(Level level, RecipeType<T> type) {
        return RecipeHelper.getRecipeMap(level, type).values().stream();
    }

    public static ItemStack cycleIngredientStack(Ingredient ingr, long displayDurationMS) {
        if (ingr.m_43947_()) {
            return ItemStack.f_41583_;
        }
        ItemStack[] items = ingr.m_43908_();
        return items[(int)(System.currentTimeMillis() % ((long)items.length * displayDurationMS) / displayDurationMS) % items.length];
    }

    public static Ingredient composeIngredient(Object ... comps) {
        return Ingredient.merge(Arrays.stream(comps).map(RecipeHelper::fromComponent).filter(i -> !i.m_43947_()).toList());
    }

    public static Ingredient fromComponent(Object comp) {
        Ingredient ingr = Ingredient.f_43901_;
        if (comp instanceof Supplier) {
            Supplier su = (Supplier)comp;
            comp = su.get();
        }
        if (comp instanceof ItemLike) {
            ingr = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)comp});
        } else if (comp instanceof IIngredientProvider) {
            ingr = ((IIngredientProvider)comp).asIngredient();
        } else if (comp instanceof ItemStack) {
            ingr = Ingredient.m_43927_((ItemStack[])new ItemStack[]{((ItemStack)comp).m_41777_()});
        } else if (comp instanceof TagKey) {
            ingr = RecipeHelper.fromTag((TagKey<Item>)((TagKey)comp));
        } else if (comp instanceof String || comp instanceof ResourceLocation) {
            String st = comp.toString();
            ingr = Ingredient.merge((Collection)OreDictionaryAdapter.get(st).stream().map(obj -> {
                if (obj != null) {
                    ResourceLocation odConv = Cast.cast(obj, ResourceLocation.class);
                    ResourceLocation tag = odConv != null ? odConv : new ResourceLocation((String)(st.contains(":") ? st : "forge:" + st));
                    return RecipeHelper.fromTag(RecipeHelper.getItemTag(tag));
                }
                return RecipeHelper.fromComponent(obj);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        } else if (comp instanceof ItemStack[]) {
            ItemStack[] items = (ItemStack[])((ItemStack[])comp).clone();
            for (int l = 0; l < items.length; ++l) {
                items[l] = items[l].m_41777_();
            }
            ingr = Ingredient.m_43927_((ItemStack[])items);
        } else if (comp instanceof Ingredient) {
            ingr = (Ingredient)comp;
        } else if (comp != null) {
            ParseIngredientEvent<Object> event = new ParseIngredientEvent<Object>(comp);
            HammerLib.postEvent(event);
            if (event.hasIngredient()) {
                ingr = event.getIngredient();
            }
        }
        return ingr;
    }

    public static TagKey<Item> getItemTag(ResourceLocation path) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)path);
    }

    public static Ingredient fromTag(TagKey<Item> tag) {
        return Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(tag)));
    }

    private static class Internal {
        private Internal() {
        }

        private static void addRecipes(RecipeManager mgr, List<Recipe<?>> recipes) {
            recipes.forEach(r -> {
                Map map = mgr.f_44007_.computeIfAbsent(r.m_6671_(), t -> new HashMap());
                map.putIfAbsent(r.m_6423_(), r);
                mgr.f_199900_.putAll(map);
            });
            HammerLib.LOG.info("Registered {} additional recipes.", (Object)recipes.size());
        }

        private static void removeRecipes(RecipeManager mgr, Supplier<Stream<ResourceLocation>> recipes) {
            recipes.get().forEach(id -> mgr.m_44043_(id).ifPresent(recipe -> {
                Map rmap = (Map)mgr.f_44007_.get(recipe.m_6671_());
                if (rmap != null) {
                    rmap.remove(id);
                }
                mgr.f_199900_.remove(id);
            }));
        }

        private static void mutableManager(RecipeManager mgr) {
            mgr.f_199900_ = new HashMap(mgr.f_199900_);
            mgr.f_44007_ = new HashMap(mgr.f_44007_);
            for (RecipeType type : mgr.f_44007_.keySet()) {
                mgr.f_44007_.put(type, new HashMap((Map)mgr.f_44007_.get(type)));
            }
        }
    }
}

