/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.shapes;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.function.BiFunction;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.zeith.hammerlib.util.java.TableHelper;

public class RotatedShapeCache<T> {
    private final Table<Direction, T, VoxelShape> cache;
    private final BiFunction<Direction, T, VoxelShape> compute;

    public RotatedShapeCache(Table<Direction, T, VoxelShape> cache, BiFunction<Direction, T, VoxelShape> compute) {
        this.cache = cache;
        this.compute = compute;
    }

    public static <T> RotatedShapeCache<T> hashBased(BiFunction<Direction, T, VoxelShape> compute) {
        return new RotatedShapeCache<T>(HashBasedTable.create((int)4, (int)12), compute);
    }

    public static <T> RotatedShapeCache<T> hashBasedSynchronized(BiFunction<Direction, T, VoxelShape> compute) {
        return new RotatedShapeCache<T>(Tables.synchronizedTable((Table)HashBasedTable.create((int)4, (int)12)), compute);
    }

    public void clear() {
        this.cache.clear();
    }

    public VoxelShape getShape(Direction rotation, T data) {
        return TableHelper.computeIfAbsent(this.cache, rotation, data, this.compute);
    }
}

