/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.ComponentInstance;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperCommon;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperMaster;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class MultiblockDropsLootContainer
extends LootPoolSingletonContainer {
    protected MultiblockDropsLootContainer(int weightIn, int qualityIn, LootItemCondition[] conditionsIn, LootItemFunction[] functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    protected void m_6948_(@Nonnull Consumer<ItemStack> output, LootContext context) {
        Object object = context.m_78953_(LootContextParams.f_81462_);
        if (object instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)object;
            IMultiblockBEHelper helper = multiblockBE.getHelper();
            this.dropOriginalBlock(helper, context, output);
            this.dropExtraItems(helper, output);
        }
    }

    private void dropOriginalBlock(IMultiblockBEHelper<?> helper, LootContext context, Consumer<ItemStack> drop) {
        BlockState originalBlock = helper.getOriginalBlock((Level)context.m_78952_());
        Utils.getDrops(originalBlock, context, drop);
    }

    private <S extends IMultiblockState> void dropExtraItems(IMultiblockBEHelper<S> iHelper, Consumer<ItemStack> drop) {
        if (!(iHelper instanceof MultiblockBEHelperCommon)) {
            return;
        }
        MultiblockBEHelperCommon helper = (MultiblockBEHelperCommon)iHelper;
        IMultiblockBEHelperMaster masterHelper = helper.getMasterHelperDuringDisassembly();
        if (masterHelper instanceof MultiblockBEHelperMaster) {
            MultiblockBEHelperMaster nonAPI = (MultiblockBEHelperMaster)masterHelper;
            for (ComponentInstance<?> component : nonAPI.getComponentInstances()) {
                component.dropExtraItems(drop);
            }
        }
        if (masterHelper != null) {
            helper.getMultiblock().logic().dropExtraItems(masterHelper.getState(), drop);
        }
    }

    public static LootPoolSingletonContainer.Builder<?> builder() {
        return MultiblockDropsLootContainer.m_79687_(MultiblockDropsLootContainer::new);
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)IELootFunctions.MULTIBLOCK_DROPS.get();
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<MultiblockDropsLootContainer> {
        @Nonnull
        protected MultiblockDropsLootContainer deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull LootItemCondition[] conditions, @Nonnull LootItemFunction[] functions) {
            return new MultiblockDropsLootContainer(weight, quality, conditions, functions);
        }
    }
}

