/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crop;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.crop.Crop;
import com.denfop.api.crop.CropItem;
import com.denfop.api.crop.EnumSoil;
import com.denfop.api.crop.genetics.GeneticsManager;
import com.denfop.api.crop.genetics.Genome;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.pollution.component.ChunkLevel;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.blockentity.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class CropNetwork {
    public static CropNetwork instance;
    Map<Integer, Crop> cropMap = new HashMap<Integer, Crop>();
    Map<ResourceKey<Level>, Map<ChunkPos, List<TileEntityCrop>>> mapWorldCrop = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<TileEntityCrop>>>();

    public static void init() {
        if (instance == null) {
            instance = new CropNetwork();
        }
    }

    public List<TileEntityCrop> getCropsFromChunk(Level world, ChunkPos chunkPos) {
        Map map = this.mapWorldCrop.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> new HashMap());
        return map.computeIfAbsent(chunkPos, k -> new ArrayList());
    }

    public void addNewCropToWorld(TileEntityCrop crop) {
        Map<ChunkPos, List<TileEntityCrop>> map = this.mapWorldCrop.get(crop.getWorld().m_46472_());
        if (map == null) {
            map = new HashMap<ChunkPos, List<TileEntityCrop>>();
            ChunkPos chunkPos = new ChunkPos(crop.getPos());
            ArrayList<TileEntityCrop> list = new ArrayList<TileEntityCrop>();
            list.add(crop);
            map.put(chunkPos, list);
            this.mapWorldCrop.put((ResourceKey<Level>)crop.getWorld().m_46472_(), map);
        } else {
            ChunkPos chunkPos = new ChunkPos(crop.getPos());
            List<TileEntityCrop> list = map.get(chunkPos);
            if (list == null) {
                list = new ArrayList<TileEntityCrop>();
                list.add(crop);
                map.put(chunkPos, list);
            } else {
                list.add(crop);
            }
        }
    }

    public void removeCropFromWorld(TileEntityCrop crop) {
        ChunkPos chunkPos;
        List<TileEntityCrop> list;
        Map<ChunkPos, List<TileEntityCrop>> map = this.mapWorldCrop.get(crop.getWorld().m_46472_());
        if (map != null && (list = map.get(chunkPos = new ChunkPos(crop.getPos()))) != null) {
            list.remove(crop);
        }
    }

    public CropNetwork getInstance() {
        return instance;
    }

    public Map<Integer, Crop> getCropMap() {
        return this.cropMap;
    }

    public Crop getCropFromStack(ItemStack stack, Genome genome) {
        if (stack.m_41720_() instanceof CropItem) {
            Crop crop = ((CropItem)stack.m_41720_()).getCrop(stack.m_41773_(), stack).copy();
            GeneticsManager.instance.loadGenomeToCrop(genome, crop);
            return crop;
        }
        return null;
    }

    public Crop getCropFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof CropItem) {
            return ((CropItem)stack.m_41720_()).getCrop(stack.m_41773_(), stack);
        }
        return IUCore.cropMap.get(stack.m_41720_());
    }

    public Crop getCrop(int id) {
        return this.cropMap.get(id);
    }

    public Crop canCropCombine(List<Crop> crops) {
        for (Crop crop : this.cropMap.values()) {
            if (!crop.isCombine() || !crop.isCombineWithCrops(crops)) continue;
            return crop.copy();
        }
        return null;
    }

    public boolean canPlantCrop(ItemStack stack, Level world, BlockPos pos, BlockState downBlock, Biome biome) {
        Crop crop = this.getCropFromStack(stack);
        if (crop == null) {
            return false;
        }
        return crop.isIgnoreSoil() || crop.getSoil().getState() == downBlock && !crop.getSoil().isIgnore() || crop.getSoil().getBlock() == downBlock.m_60734_() && crop.getSoil().isIgnore() || crop.getSoil() == EnumSoil.FARMLAND && downBlock.m_60734_() == IUItem.humus.getBlock(0) || crop.getSoil() == EnumSoil.REDSTONE && downBlock.m_60734_() == Blocks.f_50173_;
    }

    public void addCrop(Crop cropBase) {
        this.cropMap.putIfAbsent(cropBase.getId(), cropBase);
    }

    public boolean canGrow(Level world, BlockPos pos, ChunkPos chunkPos, Crop crop, Radiation radLevel, ChunkAccess chunk, Biome biome, ChunkLevel chunkLevel) {
        boolean day;
        ChunkLevel air;
        int light;
        if ((radLevel == null || radLevel.getLevel().ordinal() <= crop.getRadiationRequirements().ordinal()) && this.isWaterNearby(world, pos, crop) && (light = world.m_45524_(pos, 0)) >= crop.getLightLevel() && ((air = PollutionManager.pollutionManager.getChunkLevelAir(chunkPos)) == null || air.getLevelPollution().ordinal() <= crop.getAirRequirements().ordinal()) && (chunkLevel == null || chunkLevel.getLevelPollution().ordinal() <= crop.getSoilRequirements().ordinal()) && ((day = world.m_46461_()) && crop.isSun() || !day && crop.isNight())) {
            boolean rain = world.m_46471_();
            boolean thundering = world.m_46470_();
            return rain && crop.getWeatherResistance() >= 1 || thundering && crop.getWeatherResistance() >= 2 || !rain && !thundering;
        }
        return false;
    }

    public boolean canMultiGrow(Level world, BlockPos pos, ChunkPos chunkPos, Crop crop, Radiation radLevel, ChunkAccess chunk, Biome biome, ChunkLevel chunkLevel) {
        boolean day;
        ChunkLevel air;
        int light;
        if (radLevel.getLevel().ordinal() <= crop.getRadiationRequirements().ordinal() && (light = world.m_45524_(pos, 0)) >= crop.getLightLevel() && ((air = PollutionManager.pollutionManager.getChunkLevelAir(chunkPos)) == null || air.getLevelPollution().ordinal() <= crop.getAirRequirements().ordinal()) && (chunkLevel == null || chunkLevel.getLevelPollution().ordinal() <= crop.getSoilRequirements().ordinal()) && ((day = world.m_46461_()) && crop.isSun() || !day && crop.isNight())) {
            boolean rain = world.m_46471_();
            boolean thundering = world.m_46470_();
            return rain && crop.getWeatherResistance() >= 1 || thundering && crop.getWeatherResistance() >= 2 || !rain && !thundering;
        }
        return false;
    }

    public boolean isWaterNearby(Level world, BlockPos pos, Crop crop) {
        if (crop.getWaterRequirement() == 0) {
            return true;
        }
        int radius = crop.getWaterRequirement() + 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos = pos.m_7918_(x, -1, z);
                BlockState state = world.m_8055_(checkPos);
                if (state.m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }
}

