/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import com.denfop.api.energy.interfaces.Dual;
import com.denfop.api.energy.interfaces.EnergySource;
import com.denfop.api.energy.networking.Path;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class EnergyTick {
    private final EnergySource source;
    private final boolean isAdv;
    private final boolean isDual;
    public boolean hasHash = false;
    public List<Integer> conductors = new LinkedList<Integer>();
    private EnergySource advSource = null;
    private List<Path> energyPaths;
    private int hash;

    public EnergyTick(EnergySource source, List<Path> list) {
        this.source = source;
        this.energyPaths = list;
        this.isAdv = source != null;
        this.isDual = source instanceof Dual;
        if (this.isAdv) {
            this.advSource = source;
        }
    }

    public EnergySource getSource() {
        return this.source;
    }

    public boolean isAdv() {
        return this.isAdv;
    }

    public boolean isDual() {
        return this.isDual;
    }

    public void tick() {
        if (this.isAdv) {
            if (!this.isDual && this.advSource.isSource()) {
                this.advSource.setPastEnergy(this.advSource.getPerEnergy());
            } else if (this.isDual && this.advSource.isSource()) {
                ((Dual)this.advSource).setPastEnergy1(((Dual)this.advSource).getPerEnergy1());
            }
        }
    }

    public void addEnergy(double amount) {
        if (this.isAdv) {
            if (!this.isDual && this.advSource.isSource()) {
                this.advSource.addPerEnergy(amount);
            } else if (this.isDual && this.advSource.isSource()) {
                ((Dual)this.advSource).addPerEnergy1(amount);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnergyTick that = (EnergyTick)o;
        return this.source == that.source;
    }

    public EnergySource getAdvSource() {
        return this.advSource;
    }

    public int hashCode() {
        if (this.source != null && !this.hasHash) {
            this.hash = Objects.hash(this.source);
            this.hasHash = true;
            return this.hash;
        }
        if (this.hasHash) {
            return this.hash;
        }
        return Objects.hash(this.source);
    }

    public List<Path> getList() {
        return this.energyPaths;
    }

    public void setList(List<Path> energyPaths) {
        this.energyPaths = energyPaths;
        if (this.energyPaths == null) {
            this.conductors.clear();
        }
    }

    public void rework() {
        this.energyPaths.sort(Comparator.comparingInt(path -> path.target.getSinkTier(path.targetDirection)));
    }

    public List<Integer> getConductors() {
        return this.conductors;
    }

    public void setConductors(List<Integer> conductors) {
        this.conductors = conductors;
    }
}

