/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item.upgrade;

import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import net.minecraft.ChatFormatting;

public class UpgradeItemInform {
    public final EnumInfoUpgradeModules upgrade;
    public final int number;

    public UpgradeItemInform(EnumInfoUpgradeModules modules, int number) {
        this.upgrade = modules;
        this.number = number;
    }

    public boolean matched(EnumInfoUpgradeModules modules) {
        return this.upgrade.name.equals(modules.name);
    }

    public int getInformation(EnumInfoUpgradeModules modules) {
        if (this.upgrade.name.equals(modules.name)) {
            return this.number;
        }
        return 0;
    }

    public String getName() {
        switch (this.upgrade) {
            case GENDAY: {
                return String.valueOf(ChatFormatting.YELLOW) + Localization.translate("genday") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.05 * (double)this.number * 100.0) + "%";
            }
            case GENNIGHT: {
                return String.valueOf(ChatFormatting.AQUA) + Localization.translate("gennight") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.05 * (double)this.number * 100.0) + "%";
            }
            case PROTECTION: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("protect") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.2 * (double)this.number * 100.0) + "%";
            }
            case EFFICIENCY: {
                return String.valueOf(ChatFormatting.LIGHT_PURPLE) + Localization.translate("speed") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.2 * (double)this.number * 100.0) + "%";
            }
            case BOWENERGY: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("bowenergy") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.1 * (double)this.number * 100.0) + "%";
            }
            case SABERENERGY: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("saberenergy") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.15 * (double)this.number * 100.0) + "%";
            }
            case DIG_DEPTH: {
                return String.valueOf(ChatFormatting.AQUA) + Localization.translate("depth") + String.valueOf(ChatFormatting.GREEN) + this.number;
            }
            case FIRE_PROTECTION: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("fireResistance");
            }
            case WATER: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("waterBreathing");
            }
            case SPEED: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("moveSpeed");
            }
            case JUMP: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("jump");
            }
            case BOWDAMAGE: {
                return String.valueOf(ChatFormatting.DARK_GREEN) + Localization.translate("bowdamage") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.25 * (double)this.number * 100.0) + "%";
            }
            case SABER_DAMAGE: {
                return String.valueOf(ChatFormatting.DARK_AQUA) + Localization.translate("saberdamage") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.15 * (double)this.number * 100.0) + "%";
            }
            case AOE_DIG: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("aoe") + String.valueOf(ChatFormatting.GREEN) + this.number;
            }
            case FLYSPEED: {
                return String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("speedfly") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.1 * (double)this.number / 0.2 * 100.0) + "%";
            }
            case STORAGE: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("storage") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.05 * (double)this.number * 100.0) + "%";
            }
            case ENERGY: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("energy_less_use") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.25 * (double)this.number * 100.0) + "%";
            }
            case VAMPIRES: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("vampires") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.number);
            }
            case RESISTANCE: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("resistance") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.number);
            }
            case POISON: {
                return String.valueOf(ChatFormatting.GREEN) + Localization.translate("poison");
            }
            case WITHER: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("wither");
            }
            case SILK_TOUCH: {
                return String.valueOf(ChatFormatting.WHITE) + Localization.translate("silk");
            }
            case INVISIBILITY: {
                return String.valueOf(ChatFormatting.WHITE) + Localization.translate("invisibility");
            }
            case LOOT: {
                return String.valueOf(ChatFormatting.WHITE) + Localization.translate("loot") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.number);
            }
            case FIRE: {
                return String.valueOf(ChatFormatting.WHITE) + Localization.translate("fire") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.number);
            }
            case REPAIRED: {
                return String.valueOf(ChatFormatting.WHITE) + Localization.translate("repaired") + String.valueOf(ChatFormatting.GREEN) + 0.001 * (double)this.number + "%";
            }
            case LUCKY: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("lucky") + String.valueOf(ChatFormatting.GREEN) + this.number;
            }
            case EFFICIENT: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("efficient") + String.valueOf(ChatFormatting.GREEN) + (1 + (this.number - 1) * 2);
            }
            case SMELTER: {
                return String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.smelter");
            }
            case NIGTHVISION: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("iu.nightvision");
            }
            case THORNS: {
                return String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.thorns") + String.valueOf(ChatFormatting.GREEN) + this.number;
            }
            case EXPERIENCE: {
                return String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.experience") + String.valueOf(ChatFormatting.GOLD) + this.number * 50 + "%";
            }
            case BLINDNESS: {
                return String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.blindness");
            }
            case PROTECTION_ARROW: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("iu.protection_arrow") + String.valueOf(ChatFormatting.DARK_PURPLE) + (1 + (this.number - 1) * 2);
            }
            case FALLING_DAMAGE: {
                return String.valueOf(ChatFormatting.WHITE) + Localization.translate("iu.falling_damage") + String.valueOf(ChatFormatting.DARK_GREEN) + this.number * 25 + "%";
            }
            case MACERATOR: {
                return String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("iu.macerator");
            }
            case COMB_MACERATOR: {
                return String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("iu.comb_macerator");
            }
            case RANDOM: {
                return String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.random") + 0.001 * (double)this.number + "%";
            }
            case HUNGRY: {
                return String.valueOf(ChatFormatting.DARK_RED) + Localization.translate("iu.hungry");
            }
            case GENERATOR: {
                return String.valueOf(ChatFormatting.DARK_AQUA) + Localization.translate("iu.generator");
            }
            case FLY: {
                return String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("iu.fly_mode");
            }
            case SIZE: {
                return String.valueOf(ChatFormatting.AQUA) + Localization.translate("iu.size_mode") + this.number;
            }
            case BAGS: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.bags_mode");
            }
            case LAPPACK_ENERGY: {
                return String.valueOf(ChatFormatting.LIGHT_PURPLE) + Localization.translate("iu.lappack_mode") + 0.005 * (double)this.number + "%";
            }
            case PURIFIER: {
                return String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.purifier_mode");
            }
            case LATEX: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.latex_mode");
            }
            case WRENCH: {
                return String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.wrench_mode");
            }
        }
        return "";
    }
}

