/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.multiblock;

import com.denfop.IUCore;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.multiblock.IMultiElement;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.utils.Localization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockStructure {
    public final Map<BlockPos, Class<? extends IMultiElement>> blockPosMap = new HashMap<BlockPos, Class<? extends IMultiElement>>();
    public final Map<BlockPos, ItemStack> ItemStackMap = new HashMap<BlockPos, ItemStack>();
    public final List<ItemStack> itemStackList = new ArrayList<ItemStack>();
    public final Map<BlockPos, Direction> RotationMap = new HashMap<BlockPos, Direction>();
    public final Map<BlockPos, BakedModel> bakedModelMap = new HashMap<BlockPos, BakedModel>();
    public final BlockPos pos;
    private final Map<Class<? extends IMultiElement>, String> reportInfoMap = new HashMap<Class<? extends IMultiElement>, String>();
    public boolean hasActivatedItem = false;
    public int height;
    public int weight;
    public int length;
    public int maxHeight;
    public int minHeight;
    public int maxWeight;
    public int minWeight;
    public int maxLength;
    public int minLength;
    public boolean ignoreMetadata = false;
    public ItemStack activateItem = ItemStack.f_41583_;
    public boolean hasUniqueModels = false;
    private Class<? extends IMainMultiBlock> main;

    public MultiBlockStructure() {
        this.pos = BlockPos.f_121853_;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getHeight() {
        return this.height + 1;
    }

    public int getLength() {
        return this.length + 1;
    }

    public int getWeight() {
        return this.weight + 1;
    }

    public MultiBlockStructure setIgnoreMetadata(boolean ignoreMetadata) {
        this.ignoreMetadata = ignoreMetadata;
        return this;
    }

    public MultiBlockStructure setUniqueModel() {
        this.hasUniqueModels = true;
        return this;
    }

    public boolean isHasUniqueModels() {
        return this.hasUniqueModels;
    }

    public ItemStack getActivateItem() {
        return this.activateItem;
    }

    public MultiBlockStructure setActivateItem(ItemStack activateItem) {
        this.activateItem = activateItem;
        return this;
    }

    public boolean isActivateItem(ItemStack stack) {
        assert (stack != null);
        assert (!stack.m_41619_());
        return this.activateItem.m_41720_() == stack.m_41720_();
    }

    public boolean isHasActivatedItem() {
        return this.hasActivatedItem;
    }

    public MultiBlockStructure setHasActivatedItem(boolean hasActivatedItem) {
        this.hasActivatedItem = hasActivatedItem;
        return this;
    }

    public void add(BlockPos pos, Class<? extends IMultiElement> class1, ItemStack stack) {
        if (this.blockPosMap.containsKey(pos)) {
            return;
        }
        boolean found = false;
        for (ItemStack stack1 : this.itemStackList) {
            if (stack1.m_41720_() != stack.m_41720_()) continue;
            stack1.m_41769_(stack.m_41613_());
            found = true;
            break;
        }
        if (!found) {
            this.itemStackList.add(stack.m_41777_());
        }
        this.blockPosMap.put(pos, class1);
        this.ItemStackMap.put(pos, stack);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (y < this.minHeight) {
            this.minHeight = y;
        }
        if (y > this.maxHeight) {
            this.maxHeight = y;
        }
        if (x < this.minLength) {
            this.minLength = x;
        }
        if (x > this.maxLength) {
            this.maxLength = x;
        }
        if (z < this.minWeight) {
            this.minWeight = z;
        }
        if (z > this.maxWeight) {
            this.maxWeight = z;
        }
        this.height = this.maxHeight - this.minHeight;
        this.weight = this.maxWeight - this.minWeight;
        this.length = this.maxLength - this.minLength;
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }

    public void add(BlockPos pos, Class<? extends IMultiElement> class1, ItemStack stack, Direction rotation) {
        if (this.blockPosMap.containsKey(pos)) {
            return;
        }
        boolean found = false;
        for (ItemStack stack1 : this.itemStackList) {
            if (stack1.m_41720_() != stack.m_41720_()) continue;
            stack1.m_41769_(stack.m_41613_());
            found = true;
            break;
        }
        if (!found) {
            this.itemStackList.add(stack.m_41777_());
        }
        this.blockPosMap.put(pos, class1);
        this.ItemStackMap.put(pos, stack);
        this.RotationMap.put(pos, rotation);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (y < this.minHeight) {
            this.minHeight = y;
        }
        if (y > this.maxHeight) {
            this.maxHeight = y;
        }
        if (x < this.minLength) {
            this.minLength = x;
        }
        if (x > this.maxLength) {
            this.maxLength = x;
        }
        if (z < this.minWeight) {
            this.minWeight = z;
        }
        if (z > this.maxWeight) {
            this.maxWeight = z;
        }
        this.height = this.maxHeight - this.minHeight;
        this.weight = this.maxWeight - this.minWeight;
        this.length = this.maxLength - this.minLength;
    }

    public List<BlockPos> getPosFromClass(Direction facing, BlockPos pos, Class<? extends IMultiElement> class1) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            BlockPos pos1 = switch (facing) {
                case Direction.NORTH -> pos.m_121955_((Vec3i)entry.getKey());
                case Direction.EAST -> pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                case Direction.SOUTH -> pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            if (entry.getValue() != class1) continue;
            blockPosList.add(pos1);
        }
        return blockPosList;
    }

    public List<BlockPos> getPoses(Direction facing, BlockPos pos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            blockPosList.add(switch (facing) {
                case Direction.NORTH -> pos.m_121955_((Vec3i)entry.getKey());
                case Direction.EAST -> pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                case Direction.SOUTH -> pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            });
        }
        return blockPosList;
    }

    public boolean getFull(Direction facing, BlockPos pos, Level world, Player player) {
        IMainMultiBlock mainTile = (IMainMultiBlock)world.m_7702_(pos);
        if (mainTile == null) {
            return false;
        }
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            if (entry.getValue() == this.main) continue;
            BlockPos pos1 = switch (facing) {
                case Direction.NORTH -> pos.m_121955_((Vec3i)entry.getKey());
                case Direction.EAST -> pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                case Direction.SOUTH -> pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            BlockEntity tile = world.m_7702_(pos1);
            if (entry.getValue() == null) {
                BlockState blockstate = world.m_8055_(pos1);
                if (blockstate.m_60795_()) continue;
                return false;
            }
            if (!entry.getValue().isInstance(tile)) {
                String report = this.reportInfoMap.get(entry.getValue());
                if (report != null && !report.isEmpty()) {
                    if (!world.f_46443_) {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.not.found") + "x: " + pos1.m_123341_() + " y: " + pos1.m_123342_() + " z: " + pos1.m_123343_() + " " + Localization.translate(report));
                    }
                } else if (!world.f_46443_) {
                    IUCore.proxy.messagePlayer(player, Localization.translate("iu.not.found") + "x: " + pos1.m_123341_() + " y: " + pos1.m_123342_() + " z: " + pos1.m_123343_() + " " + this.ItemStackMap.get(entry.getKey()).m_41611_().getString());
                }
                return false;
            }
            IMultiElement element = (IMultiElement)tile;
            if (element.isMain() && element.getMain() != mainTile || element.getBlockLevel() != mainTile.getBlockLevel() && element.getBlockLevel() != -1 || !element.canCreateSystem(mainTile)) {
                return false;
            }
            if (element.getMain() != null && element.getMain() != mainTile) {
                IMainMultiBlock mainTwo = element.getMain();
                element.setMainMultiElement(mainTile);
                mainTwo.updateFull();
                if (!mainTwo.wasActivated()) continue;
                mainTwo.setActivated(false);
                continue;
            }
            if (element.getMain() != null) continue;
            element.setMainMultiElement(mainTile);
        }
        return true;
    }

    public boolean getFull(Direction facing, BlockPos pos, Level world) {
        IMainMultiBlock mainTile = (IMainMultiBlock)world.m_7702_(pos);
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            if (entry.getValue() == this.main) continue;
            BlockPos pos1 = switch (facing) {
                case Direction.NORTH -> pos.m_121955_((Vec3i)entry.getKey());
                case Direction.EAST -> pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                case Direction.SOUTH -> pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            BlockEntity tile = world.m_7702_(pos1);
            if (entry.getValue() == null) {
                BlockState blockstate = world.m_8055_(pos1);
                if (blockstate.m_60795_()) continue;
                return false;
            }
            if (!entry.getValue().isInstance(tile)) {
                return false;
            }
            IMultiElement element = (IMultiElement)tile;
            if (element.getMain() != null && element.getMain() != mainTile || element.getBlockLevel() != mainTile.getBlockLevel() && element.getBlockLevel() != -1 || !element.canCreateSystem(mainTile)) {
                return false;
            }
            if (element.getMain() != null) continue;
            element.setMainMultiElement(mainTile);
        }
        return true;
    }

    public MultiBlockStructure setMain(Class<? extends IMainMultiBlock> main) {
        this.main = main;
        return this;
    }

    public void addReport(Class<? extends IMultiElement> name, String report) {
        this.reportInfoMap.put(name, report);
    }

    public void markDirty(BlockEntityMultiBlockBase tileMultiBlockBase, boolean full) {
        ArrayList<ChunkPos> passedChunk = new ArrayList<ChunkPos>();
        if (full) {
            for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
                BlockEntity tile;
                if (entry.getValue() == this.main) continue;
                Level world = tileMultiBlockBase.m_58904_();
                BlockPos pos1 = null;
                BlockPos pos = tileMultiBlockBase.m_58899_();
                if (!((tile = world.m_7702_(pos1 = (switch (tileMultiBlockBase.getFacing()) {
                    case Direction.NORTH -> pos.m_121955_((Vec3i)entry.getKey());
                    case Direction.EAST -> pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                    case Direction.WEST -> pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                    case Direction.SOUTH -> pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                    default -> pos1;
                }))) instanceof BlockEntityMultiBlockElement)) continue;
                BlockEntityMultiBlockElement te = (BlockEntityMultiBlockElement)world.m_7702_(pos1);
                te.setMainMultiElement(tileMultiBlockBase);
                ChunkPos chunkPos = new ChunkPos(pos1);
                if (passedChunk.contains(chunkPos)) continue;
                passedChunk.add(chunkPos);
            }
        } else {
            for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
                BlockEntity tile;
                if (entry.getValue() == this.main) continue;
                Level world = tileMultiBlockBase.m_58904_();
                BlockPos pos1 = null;
                BlockPos pos = tileMultiBlockBase.m_58899_();
                switch (tileMultiBlockBase.getFacing()) {
                    case NORTH: {
                        pos1 = pos.m_121955_((Vec3i)entry.getKey());
                        break;
                    }
                    case EAST: {
                        pos1 = pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                        break;
                    }
                    case WEST: {
                        pos1 = pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                        break;
                    }
                    case SOUTH: {
                        pos1 = pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                    }
                }
                if (!((tile = world.m_7702_(pos1)) instanceof BlockEntityMultiBlockElement)) continue;
                BlockEntityMultiBlockElement te = (BlockEntityMultiBlockElement)world.m_7702_(pos1);
                te.setMainMultiElement(null);
                ChunkPos chunkPos = new ChunkPos(pos1);
                if (passedChunk.contains(chunkPos)) continue;
                passedChunk.add(chunkPos);
            }
        }
    }
}

