/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.inventory.Inventory;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class InventoryOutput
extends Inventory {
    public InventoryOutput(CustomWorldContainer base1, int count) {
        super(base1, Inventory.TypeItemSlot.OUTPUT, count);
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return false;
    }

    @Override
    public boolean addAll(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    public void add(ItemStack stack, int size) {
        int count = size * stack.m_41613_();
        for (int i = 0; i < this.size(); ++i) {
            int size1;
            ItemStack slot = this.get(i);
            if (slot.m_41619_()) {
                size1 = Math.min(count, stack.m_41741_());
                slot = stack.m_41777_();
                slot.m_41764_(size1);
                this.set(i, slot);
                if ((count -= size1) != 0) continue;
                return;
            }
            if (!ModUtils.checkItemEquality(slot, stack) || slot.m_41613_() == stack.m_41741_()) continue;
            if (stack.m_41783_() == null && slot.m_41783_() == null) {
                size1 = Math.min(count, stack.m_41741_() - slot.m_41613_());
                this.get(i).m_41769_(size1);
                if ((count -= size1) != 0) continue;
                return;
            }
            if (!ModUtils.checkNbtEquality(stack.m_41783_(), slot.m_41783_())) continue;
            size1 = Math.min(count, stack.m_41741_() - slot.m_41613_());
            this.get(i).m_41769_(size1);
            if ((count -= size1) != 0) continue;
            return;
        }
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    public boolean add(List<ItemStack> stacks, int size) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).m_41619_()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!ModUtils.checkItemEquality(this.get(i), stack) || this.get(i).m_41613_() + stack.m_41613_() * size > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        this.get(i).m_41769_(stack.m_41613_() * size);
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(stack.m_41783_(), this.get(i).m_41783_())) continue;
                    this.get(i).m_41769_(stack.m_41613_() * size);
                    return true;
                }
                if (minSlot == this.size()) continue;
                stack = stack.m_41777_();
                stack.m_41764_(stack.m_41613_() * size);
                this.set(minSlot, stack);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).m_41619_()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!ModUtils.checkItemEquality(this.get(i), stack) || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                        }
                        return true;
                    }
                    if (!NbtUtils.m_129235_((Tag)stack.m_41783_(), (Tag)this.get(i).m_41783_(), (boolean)true)) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                    }
                    return true;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.set(minSlot, stack.m_41777_());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean addWithoutIgnoring(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            int col = 0;
            block0: for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).m_41619_()) {
                        if (i >= minSlot || linkedList.contains(i)) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!ModUtils.checkItemEquality(this.get(i), stack) || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                        }
                        ++col;
                        linkedList.add(i);
                        continue block0;
                    }
                    if (!ModUtils.checkNbtEquality(stack.m_41783_(), this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                    }
                    ++col;
                    linkedList.add(i);
                    continue block0;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.set(minSlot, stack.m_41777_());
                }
                ++col;
                linkedList.add(minSlot);
            }
            return col == stacks.size();
        }
        return true;
    }
}

