/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class RecipeInfo {
    private final ItemStack stack;
    private final double col;

    public RecipeInfo(ItemStack stack, double col) {
        this.stack = stack;
        this.col = col;
    }

    public RecipeInfo(CompoundTag tagCompound) {
        this.stack = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("stack"));
        this.col = tagCompound.m_128459_("matter");
    }

    public RecipeInfo(CustomPacketBuffer packetBuffer) {
        this.col = packetBuffer.readDouble();
        try {
            this.stack = (ItemStack)DecoderHandler.decode(packetBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer getPacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeDouble(this.col);
        try {
            EncoderHandler.encode(packetBuffer, this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    public double getCol() {
        return this.col;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public CompoundTag writeCompound() {
        CompoundTag tag = new CompoundTag();
        CompoundTag stackNBT = new CompoundTag();
        this.stack.m_41739_(stackNBT);
        tag.m_128365_("stack", (Tag)stackNBT);
        tag.m_128347_("matter", this.col);
        return tag;
    }
}

