/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IOxygenFactory;
import com.denfop.api.space.colonies.enums.EnumProblems;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.api.space.colonies.enums.EnumTypeOxygenFactory;
import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.nbt.CompoundTag;

public class OxygenFactory
extends Building
implements IOxygenFactory {
    private final EnumTypeOxygenFactory type;
    private byte people;

    public OxygenFactory(IColony colonies, EnumTypeOxygenFactory oxygenFactory, boolean simulate) {
        super(colonies);
        this.type = oxygenFactory;
        this.people = 0;
        if (!simulate) {
            this.getColony().addMaxOxygen(this.getMax());
            this.getColony().addBuilding(this);
        }
    }

    public OxygenFactory(CustomPacketBuffer packetBuffer, Colony colony) {
        super(colony);
        this.type = EnumTypeOxygenFactory.values()[packetBuffer.readByte()];
        this.people = packetBuffer.readByte();
        this.getColony().addMaxOxygen(this.getMax());
        this.getColony().addBuilding(this);
    }

    public OxygenFactory(CompoundTag tag, IColony colonie) {
        super(colonie);
        this.type = EnumTypeOxygenFactory.values()[tag.m_128445_("id")];
        this.people = tag.m_128445_("people");
        this.getColony().addMaxOxygen(this.getMax());
        this.getColony().addBuilding(this);
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte(this.type.ordinal());
        customPacketBuffer.writeByte(this.people);
        return customPacketBuffer;
    }

    @Override
    public int getMinLevelColony() {
        return this.type.getLevel();
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public int getMax() {
        return 5000;
    }

    @Override
    public int getGeneration() {
        return this.type.getGeneration() * 100;
    }

    @Override
    public int getEnergy() {
        return this.type.getEnergy();
    }

    @Override
    public int needWorkers() {
        return this.type.getPeople() - this.people;
    }

    @Override
    public int getPeople() {
        return this.people;
    }

    @Override
    public void addWorkers(int workers) {
        this.people = (byte)(this.people + (byte)workers);
    }

    @Override
    public void removeWorkers(int remove) {
        this.people = (byte)(this.people - remove);
    }

    @Override
    public int getWorkers() {
        return this.people;
    }

    @Override
    public EnumTypeOxygenFactory getType() {
        return this.type;
    }

    @Override
    public void work() {
        if (this.getColony().getOxygen() < this.getColony().getMaxOxygen()) {
            if (this.getColony().getEnergy() >= this.type.getEnergy()) {
                this.getColony().useEnergy(this.type.getEnergy());
                this.getColony().addOxygen(this.getGeneration());
            } else if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
        }
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.OXYGEN;
    }

    @Override
    public CompoundTag writeTag(CompoundTag tag) {
        super.writeTag(tag);
        tag.m_128344_("id", (byte)this.type.ordinal());
        tag.m_128344_("people", this.people);
        return tag;
    }
}

