/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.upgrades;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.api.ISpaceUpgradeSystem;
import com.denfop.api.space.upgrades.event.EventItemLoad;
import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BaseSpaceUpgradeSystem
implements ISpaceUpgradeSystem {
    public static List<Runnable> list = new ArrayList<Runnable>();
    Map<Integer, List<SpaceUpgradeItemInform>> map = new HashMap<Integer, List<SpaceUpgradeItemInform>>();
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col = new HashMap<Integer, Integer>();
    int max = 0;

    public BaseSpaceUpgradeSystem() {
        this.map_stack = new HashMap<Integer, ItemStack>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("roverupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1)), input.getInput(fill)), new RecipeOutput(null, new ItemStack((ItemLike)container, 1))));
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @Override
    public int getRemaining(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        return this.map_col.getOrDefault(id, 24);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        ItemStack item = this.map_stack.get(id);
        if (item == null || item.m_41619_()) {
            return false;
        }
        int id1 = ModUtils.nbt(item).m_128451_("ID_Item");
        return item.m_150930_(stack.m_41720_()) && id1 == id && item.m_41783_() != null && item.m_41783_().equals((Object)stack.m_41783_());
    }

    @Override
    public List<SpaceUpgradeItemInform> getInformation(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        List<SpaceUpgradeItemInform> list = this.map.get(id);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public SpaceUpgradeItemInform getModules(EnumTypeUpgrade module, ItemStack item) {
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumTypeUpgrade module, ItemStack item) {
        if (!(item.m_41720_() instanceof IRoversItem)) {
            return false;
        }
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IRoversItem item, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.m_128471_("hasID");
        int id = nbt.m_128451_("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.m_128405_("ID_Item", id);
            nbt.m_128379_("hasID", true);
        }
        ListTag modesTagList = nbt.m_128437_("modes", 10);
        ArrayList<EnumTypeUpgrade> lst = new ArrayList<EnumTypeUpgrade>();
        for (int i = 0; i < modesTagList.size(); ++i) {
            CompoundTag modeTag = modesTagList.m_128728_(i);
            int index = modeTag.m_128451_("index");
            lst.add(EnumTypeUpgrade.getFromID(index));
        }
        int ost = 24 - modesTagList.size();
        nbt.m_128379_("canupgrade", ost > 0);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        this.setInformation(item, lst, stack);
    }

    @Override
    public void setInformation(IRoversItem item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        this.map.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
    }

    @Override
    public void write(IRoversItem item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        Map<EnumTypeUpgrade, Integer> moduleCounts = lst.stream().collect(Collectors.toMap(module -> module, module -> 1, Integer::sum));
        List upgrades = moduleCounts.entrySet().stream().map(entry -> new SpaceUpgradeItemInform((EnumTypeUpgrade)((Object)((Object)entry.getKey())), (Integer)entry.getValue())).collect(Collectors.toList());
        this.map.put(id, upgrades);
        this.map_stack.put(id, stack);
    }

    private int getModulesValue(EnumTypeUpgrade module, ItemStack stack) {
        SpaceUpgradeItemInform modules = this.getModules(module, stack);
        if (modules == null) {
            return 0;
        }
        return modules.number;
    }

    @Override
    public void removeUpdate(ItemStack stack, Level world, int index) {
        CompoundTag nbt = ModUtils.nbt(stack);
        ListTag modesTagList = nbt.m_128437_("modes", 10);
        int i = 0;
        for (int ii = 0; ii < modesTagList.size(); ++ii) {
            CompoundTag tagCompound = modesTagList.m_128728_(ii);
            if (tagCompound.m_128451_("index") != index) continue;
            i = ii;
            break;
        }
        modesTagList.remove(i);
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (IRoversItem)stack.m_41720_(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        CompoundTag nbt = ModUtils.nbt(stack);
        ListTag modesTagList = nbt.m_128437_("modes", 10);
        for (int ii = 0; ii < modesTagList.size(); ++ii) {
            CompoundTag tagCompound = modesTagList.m_128728_(ii);
            list.add(new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(tagCompound.m_128451_("index")), 1));
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, EnumTypeUpgrade ... lst) {
        for (EnumTypeUpgrade upgrades : lst) {
            BaseSpaceUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(upgrades.ordinal()), 1));
        }
    }

    @Override
    public boolean shouldUpdate(EnumTypeUpgrade type, ItemStack stack1) {
        List<SpaceUpgradeItemInform> list = this.getInformation(stack1);
        for (SpaceUpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.getMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAvailableUpgrade(IRoversItem iUpgradeItem, ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        List<SpaceUpgradeItemInform> list = this.map.get(id);
        List<EnumTypeUpgrade> list1 = iUpgradeItem.getUpgradeModules();
        LinkedList<CallSite> stringList = new LinkedList<CallSite>();
        block0: for (EnumTypeUpgrade enumInfoUpgradeModules : list1) {
            for (SpaceUpgradeItemInform upgradeItemInform : list) {
                if (!upgradeItemInform.upgrade.equals((Object)enumInfoUpgradeModules)) continue;
                if (upgradeItemInform.number >= upgradeItemInform.upgrade.getMax()) continue block0;
                stringList.add((CallSite)((Object)(String.valueOf(ChatFormatting.GREEN) + (upgradeItemInform.upgrade.getMax() - upgradeItemInform.number) + "x " + new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(enumInfoUpgradeModules.ordinal()), 1).m_41611_().getString())));
                continue block0;
            }
            stringList.add((CallSite)((Object)(String.valueOf(ChatFormatting.GREEN) + enumInfoUpgradeModules.getMax() + "x " + new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(enumInfoUpgradeModules.ordinal()), 1).m_41611_().getString())));
        }
        return list != null ? stringList : Collections.emptyList();
    }
}

