/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.steam;

import com.denfop.api.steam.EnumSteamPhase;
import com.denfop.api.steam.ICoolant;
import com.denfop.api.steam.IExchanger;
import com.denfop.api.steam.ISteam;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.blockentity.mechanism.steamturbine.IRod;
import com.denfop.world.WorldBaseGen;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class Steam {
    private static final Random random = WorldBaseGen.random;
    private final ISteam steam;
    private double coef;

    public Steam(ISteam steam) {
        this.steam = steam;
        this.updateData();
    }

    public double getCoef() {
        return this.coef;
    }

    public void onTick() {
        if (this.steam.isWork() && this.coef > 0.0) {
            boolean update = false;
            FluidTank steamTank = this.steam.getSteamFluid();
            FluidTank waterTank = this.steam.getWaterFluid();
            if (steamTank.getFluidAmount() > 0 && steamTank.getFluidAmount() - this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1) >= 0) {
                int canAdd = waterTank.getCapacity() - waterTank.getFluidAmount();
                canAdd = Math.min(canAdd, this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1));
                steamTank.drain(this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1), IFluidHandler.FluidAction.EXECUTE);
                if (canAdd > 0) {
                    waterTank.fill(new FluidStack((Fluid)Fluids.f_76193_, canAdd), IFluidHandler.FluidAction.EXECUTE);
                }
                if (random.nextInt(5) <= 1 && this.steam.getHeat() < this.steam.getMaxHeat() * 0.5 && this.steam.getSteamPhase().ordinal() <= this.steam.getStableSteamPhase().ordinal()) {
                    this.steam.addPhase(random.nextInt(this.steam.getPressure() + 1));
                } else if (this.steam.getHeat() >= this.steam.getMaxHeat() * 0.5 && this.steam.getHeat() < this.steam.getMaxHeat() * 0.75 || this.steam.getSteamPhase().ordinal() > this.steam.getStableSteamPhase().ordinal()) {
                    this.steam.removePhase(random.nextInt(2));
                } else if (this.steam.getHeat() >= this.steam.getMaxHeat() * 0.75) {
                    this.steam.removePhase(random.nextInt(4));
                }
                this.steam.addHeat(this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1));
                for (ICoolant iCoolant : this.steam.getCoolant()) {
                    if (iCoolant.getCoolant().getFluid().isEmpty() || iCoolant.getCoolant().getFluid().getAmount() < iCoolant.getPressure()) continue;
                    this.steam.removeHeat(iCoolant.getPower());
                    iCoolant.getCoolant().drain(iCoolant.getPressure(), IFluidHandler.FluidAction.EXECUTE);
                }
                for (IExchanger iExchanger : this.steam.getExchanger()) {
                    if (iExchanger.getSlot().m_7983_()) continue;
                    this.steam.removeHeat(iExchanger.getPower() * 6.0);
                }
            } else {
                this.steam.removePhase(random.nextInt(5));
            }
            for (IRod rod : this.steam.getInfo()) {
                int n = 0;
                for (ItemStack stack : rod.getSlot()) {
                    if (stack.m_41619_()) continue;
                    ISteamBlade steamBlade = rod.getRods().get(n);
                    update = update || steamBlade.damageBlade(stack);
                    ++n;
                }
            }
            this.steam.setGeneration(this.getGeneration());
            if (update) {
                this.steam.updateInfo();
                this.updateData();
            }
        }
    }

    public double getGeneration() {
        EnumSteamPhase type = this.steam.getSteamPhase();
        return this.coef * (double)this.steam.getPhase() * (double)(type.ordinal() + 1) * 0.98;
    }

    public void updateData() {
        this.coef = 0.0;
        for (IRod entry : this.steam.getInfo()) {
            AtomicReference<Double> coefBlade = new AtomicReference<Double>(0.0);
            entry.getRods().forEach(steamBlade -> coefBlade.updateAndGet(v -> v + steamBlade.getCoef()));
            this.coef += coefBlade.get().doubleValue();
        }
    }
}

