/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.MouseButton;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.items.ItemPipette;
import com.denfop.network.packet.PacketDrainFluidPipette;
import com.denfop.screen.ScreenAdvCokeOven;
import com.denfop.screen.ScreenBlastFurnace;
import com.denfop.screen.ScreenCokeOven;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TankWidget
extends ScreenWidget {
    public static final int v = 100;
    protected final IFluidTank tank;

    public TankWidget(ScreenIndustrialUpgrade<?> gui, int x, int y, int width, int height, IFluidTank tank) {
        super(gui, x, y, width, height);
        if (tank == null) {
            throw new NullPointerException("null tank");
        }
        this.tank = tank;
    }

    public static TankWidget createNormal(ScreenIndustrialUpgrade<?> gui, int x, int y, IFluidTank tank) {
        return new TankWidget(gui, x, y, 20, 55, tank);
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY, MouseButton button) {
        IFluidTank iFluidTank;
        if (this.visible() && this.contains(mouseX, mouseY) && !this.tank.getFluid().isEmpty() && (iFluidTank = this.tank) instanceof Fluids.InternalFluidTank) {
            Fluids.InternalFluidTank fluidTank = (Fluids.InternalFluidTank)iFluidTank;
            iFluidTank = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().m_41720_();
            if (iFluidTank instanceof ItemPipette) {
                ItemPipette pipette = (ItemPipette)iFluidTank;
                IFluidHandlerItem handler = FluidHandlerFix.getFluidHandler(Minecraft.m_91087_().f_91074_.f_36096_.m_142621_());
                BlockEntityBase block = (BlockEntityBase)((Object)((ContainerMenuBase)((Object)this.gui.container)).base);
                ComponentSteamEnergy steamEnergy = block.getComp(ComponentSteamEnergy.class);
                ComponentBioFuelEnergy bioEnergy = block.getComp(ComponentBioFuelEnergy.class);
                if (steamEnergy != null && !steamEnergy.getFluidTank().getFluid().isEmpty() && steamEnergy.getFluidTank().getFluid().getAmount() == this.tank.getFluid().getAmount() && steamEnergy.getFluidTank().getFluid().isFluidEqual(this.tank.getFluid())) {
                    return false;
                }
                if (bioEnergy != null && !bioEnergy.getFluidTank().getFluid().isEmpty() && bioEnergy.getFluidTank().getFluid().getAmount() == this.tank.getFluid().getAmount() && bioEnergy.getFluidTank().getFluid().isFluidEqual(this.tank.getFluid())) {
                    return false;
                }
                if (this.gui instanceof ScreenBlastFurnace || this.gui instanceof ScreenCokeOven || this.gui instanceof ScreenAdvCokeOven) {
                    return false;
                }
                if (handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).isFluidEqual(fluidTank.getFluid())) {
                    this.getGui().getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    new PacketDrainFluidPipette((BlockEntity)((ContainerMenuBase)((Object)this.gui.container)).base, fluidTank.getIdentifier(), Math.min(fluidTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount(), handler.getTankCapacity(0) - handler.getFluidInTank(0).getAmount()));
                }
            }
        }
        return super.onMouseClick(mouseX, mouseY, button);
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        TankWidget.bindCommonTexture();
        FluidStack fs = this.tank.getFluid();
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.f_93618_, this.f_93619_);
            int fluidX = this.x;
            int fluidY = this.y;
            fluidX += 4;
            fluidY += 4;
            int fluidWidth = 12;
            int fluidHeight = 47;
            Fluid fluid = fs.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = TankWidget.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
            TankWidget.bindBlockTexture();
            this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
            TankWidget.bindCommonTexture();
            int gaugeX = this.x;
            int gaugeY = this.y;
            this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
        } else {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.f_93618_, this.f_93619_);
        }
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.tank.getFluid();
        if (KeyboardIU.isKeyDown(340)) {
            if (this.tank instanceof Fluids.InternalFluidTank) {
                Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                ret.add(Localization.translate("iu.tank.fluids"));
                ret.addAll(tank1.getFluidList());
            }
        } else if (!fs.isEmpty() && fs.getAmount() > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(Localization.translate(fs.getFluid().getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
            } else {
                ret.add("invalid fluid stack");
            }
        } else {
            ret.add(Localization.translate("iu.generic.text.empty"));
        }
        return ret;
    }

    public static enum TankGuiStyle {
        Normal(true, true, false),
        Borderless(false, true, false),
        BorderlessMirrored(false, true, true),
        Plain(false, false, false);

        public final boolean withBorder;
        public final boolean withGauge;
        public final boolean mirrorGauge;

        private TankGuiStyle(boolean withBorder, boolean withGauge, boolean mirrorGauge) {
            this.withBorder = withBorder;
            this.withGauge = withGauge;
            this.mirrorGauge = mirrorGauge;
        }
    }
}

