/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.Upgrade;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.containermenu.ContainerMenuAutomaticMechanism;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.SlotInfo;
import com.denfop.inventory.HandlerInventory;
import com.denfop.inventory.Inventory;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenAutomaticMechanism;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class BlockEntityAutomaticMechanism
extends BlockEntityInventory
implements IUpdatableTileEvent {
    public final SlotInfo slot;
    public final Inventory slotOI;
    public final Map<Direction, HandlerInventory> iItemHandlerMap = new HashMap<Direction, HandlerInventory>();
    public final Map<IItemHandler, Integer> slotHandler = new HashMap<IItemHandler, Integer>();
    private final IItemHandler main_handler;
    public Map<Direction, Upgrade> typeUpgradeMap = new HashMap<Direction, Upgrade>();
    public Map<Direction, List<ItemStack>> extract = new HashMap<Direction, List<ItemStack>>();
    public Map<Direction, List<ItemStack>> pulling = new HashMap<Direction, List<ItemStack>>();
    private int type = 0;
    private boolean put = false;

    public BlockEntityAutomaticMechanism(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.automatic_mechanism, pos, state);
        this.slot = new SlotInfo(this, 36, false){

            @Override
            public ItemStack set(int index, ItemStack stack) {
                super.set(index, stack);
                ((BlockEntityAutomaticMechanism)this.base).updateList();
                return stack;
            }
        };
        this.slotOI = new Inventory(this, Inventory.TypeItemSlot.INPUT_OUTPUT, 24){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                BlockEntityAutomaticMechanism.this.put = true;
                return content;
            }
        };
        for (Direction facing1 : Direction.values()) {
            this.typeUpgradeMap.put(facing1, Upgrade.NONE);
        }
        this.main_handler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getFacing()).orElse(null);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.automation_mechanism.info"));
        tooltip.add(Localization.translate("iu.automation_mechanism.info1"));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        for (Direction facing1 : Direction.values()) {
            customPacketBuffer.writeInt(this.typeUpgradeMap.get(facing1).ordinal());
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        for (Direction facing1 : Direction.values()) {
            this.typeUpgradeMap.replace(facing1, Upgrade.values()[customPacketBuffer.readInt()]);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.typeUpgradeMap.clear();
        for (Direction facing1 : Direction.values()) {
            this.typeUpgradeMap.put(facing1, Upgrade.values()[nbtTagCompound.m_128451_(facing1.name().toLowerCase())]);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt = super.writeToNBT(nbt);
        for (Direction facing1 : this.typeUpgradeMap.keySet()) {
            nbt.m_128405_(facing1.name().toLowerCase(), this.typeUpgradeMap.get(facing1).ordinal());
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.updateList();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            this.iItemHandlerMap.clear();
            this.slotHandler.clear();
            for (Direction facing : Direction.values()) {
                BlockPos pos = this.getPos().m_121955_(facing.m_122436_());
                BlockEntity tile1 = this.getWorld().m_7702_(pos);
                IItemHandler handler = ModUtils.getItemHandler(tile1, facing.m_122424_());
                if (!(tile1 instanceof Container)) {
                    if (handler == null) {
                        this.iItemHandlerMap.put(facing, null);
                    } else {
                        this.iItemHandlerMap.put(facing, new HandlerInventory(handler, null));
                    }
                } else {
                    this.iItemHandlerMap.put(facing, new HandlerInventory(handler, (Container)tile1));
                }
                if (handler == null) continue;
                this.slotHandler.put(handler, handler.getSlots());
            }
        }
        if (this.f_58857_.m_46467_() % 3L == 0L) {
            for (Map.Entry entry : this.typeUpgradeMap.entrySet()) {
                switch ((Upgrade)((Object)entry.getValue())) {
                    case EXTRACT: {
                        this.tick((Direction)entry.getKey());
                        break;
                    }
                    case PULLING: {
                        this.tickPullIn((Direction)entry.getKey());
                        break;
                    }
                    case EXT_PUL: {
                        this.tick((Direction)entry.getKey());
                        this.tickPullIn((Direction)entry.getKey());
                    }
                }
            }
        }
    }

    private void tickPullIn(Direction facing) {
        block22: {
            List itemStackList = this.pulling.getOrDefault(facing, Collections.emptyList());
            if (facing == null) break block22;
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (handler.getInventory() != null && handler.getInventory() instanceof BlockEntityInventory) {
                List<Inventory> inputs = this.getInputSlots();
                BlockEntityInventory inventory = (BlockEntityInventory)handler.getInventory();
                List<Inventory> outputs = inventory.getOutputSlots();
                for (Inventory slot : outputs) {
                    for (Inventory invSlot : inputs) {
                        ItemStack input;
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.m_41619_() || output.m_41613_() == output.m_41741_()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!ModUtils.checkItemEquality(stack, output)) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.m_7013_(0, output)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                    int maxCount;
                                    input = invSlot.get(jj);
                                    if (input.m_41619_()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.set(j, ItemStack.f_41583_);
                                        output = ItemStack.f_41583_;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                    input.m_41769_(maxCount);
                                    output.m_41774_(maxCount);
                                }
                            }
                            continue;
                        }
                        block7: for (int jj = 0; jj < slot.size(); ++jj) {
                            ItemStack output;
                            for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).m_41619_(); ++j) {
                                int maxCount;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    input = itemStackList.iterator();
                                    while (input.hasNext()) {
                                        ItemStack stack = (ItemStack)input.next();
                                        if (!stack.m_150930_(output.m_41720_())) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block7;
                                }
                                if ((input = invSlot.get(j)).m_41619_()) {
                                    if (!invSlot.m_7013_(j, output) || !invSlot.add(output)) continue;
                                    slot.set(jj, ItemStack.f_41583_);
                                    output = ItemStack.f_41583_;
                                    continue;
                                }
                                if (!output.m_150930_(input.m_41720_()) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                input.m_41769_(maxCount);
                                output.m_41774_(maxCount);
                            }
                        }
                    }
                }
            } else {
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took1;
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.m_41619_()) continue;
                    boolean find = false;
                    if (!itemStackList.isEmpty()) {
                        for (ItemStack stack : itemStackList) {
                            if (!stack.m_150930_(took.m_41720_())) continue;
                            find = true;
                            break;
                        }
                        if (!find) continue;
                    }
                    if ((took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots())).m_41619_()) {
                        took = handler.getHandler().extractItem(j, took.m_41613_(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.m_41613_() - took.m_41613_();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        }
    }

    private void tick(Direction facing) {
        block27: {
            List itemStackList = this.extract.getOrDefault(facing, Collections.emptyList());
            if (facing == null) break block27;
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            if (handler.getInventory() != null && handler.getInventory() instanceof BlockEntityInventory) {
                BlockEntityInventory inventory = (BlockEntityInventory)handler.getInventory();
                Inventory slot = this.slotOI;
                for (Inventory invSlot : inventory.getInputSlots()) {
                    if (invSlot.acceptAllOrIndex()) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack output = slot.get(j);
                            if (output.m_41619_()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.m_150930_(output.m_41720_())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if (!invSlot.m_7013_(0, output)) continue;
                            for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                int maxCount;
                                ItemStack input = invSlot.get(jj);
                                if (input.m_41619_()) {
                                    if (!invSlot.add(output)) continue;
                                    slot.set(j, ItemStack.f_41583_);
                                    output = ItemStack.f_41583_;
                                    continue;
                                }
                                if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                input.m_41769_(maxCount);
                                output.m_41774_(maxCount);
                            }
                        }
                        continue;
                    }
                    block6: for (int jj = 0; jj < slot.size(); ++jj) {
                        for (int j = 0; j < invSlot.size(); ++j) {
                            int maxCount;
                            ItemStack output = slot.get(jj);
                            ItemStack input = invSlot.get(j);
                            if (output.m_41619_()) continue block6;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.m_150930_(output.m_41720_())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue block6;
                            }
                            if (input.m_41619_()) {
                                if (!invSlot.m_7013_(j, output) || !invSlot.add(output)) continue;
                                slot.set(jj, ItemStack.f_41583_);
                                output = ItemStack.f_41583_;
                                continue;
                            }
                            if (!output.m_150930_(input.m_41720_()) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                            input.m_41769_(maxCount);
                            output.m_41774_(maxCount);
                        }
                    }
                }
            } else {
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    Inventory slot = this.slotOI;
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack stack;
                        ItemStack took = slot.get(j);
                        if (took.m_41619_()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack2 : itemStackList) {
                                if (!stack2.m_150930_(took.m_41720_())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        if ((stack = this.insertItem1(handler, took, true, slots)).m_41619_()) {
                            slot.set(j, ItemStack.f_41583_);
                            this.insertItem1(handler, took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).m_41613_() - stack.m_41613_();
                        slot.get(j).m_41774_(col);
                        stack.m_41764_(col);
                        this.insertItem1(handler, stack, false, slots);
                    }
                } else {
                    Inventory slot = this.slotOI;
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack took = slot.get(j);
                        if (took.m_41619_()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.m_150930_(took.m_41720_())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = took.m_41777_();
                        ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.m_41619_()) {
                            slot.set(j, ItemStack.f_41583_);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).m_41613_() - stack.m_41613_();
                        slot.get(j).m_41774_(col);
                        stack.m_41764_(col);
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItem1(HandlerInventory dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = this.insertItem2(dest, i, stack, simulate);
            if (stack2.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    public boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41619_() || !a.m_150930_(b.m_41720_()) || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return !a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_());
    }

    @Nonnull
    public ItemStack insertItem2(HandlerInventory dest1, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack stackInSlot;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler dest = dest1.getHandler();
        Container inventory = dest1.getInventory();
        try {
            stackInSlot = inventory.m_8020_(slot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            stackInSlot = dest.getStackInSlot(slot);
        }
        if (!stackInSlot.m_41619_()) {
            int max = stackInSlot.m_41741_();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.m_41613_() >= Math.min(max, limit)) {
                return stack;
            }
            if (simulate && !inventory.m_7013_(slot, stack)) {
                return stack;
            }
            if (!this.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    inventory.m_6836_(slot, copy);
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                inventory.m_6836_(slot, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!inventory.m_7013_(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), dest.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                inventory.m_6836_(slot, stack.m_41620_(m));
            }
            return stack;
        }
        if (!simulate) {
            try {
                inventory.m_6836_(slot, stack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                dest.insertItem(slot, stack, false);
            }
        }
        return ItemStack.f_41583_;
    }

    public ContainerMenuAutomaticMechanism getGuiContainer(Player var1) {
        return new ContainerMenuAutomaticMechanism(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAutomaticMechanism((ContainerMenuAutomaticMechanism)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.automatic_mechanism;
    }

    private void updateList() {
        this.extract.clear();
        this.pulling.clear();
        block5: for (Direction facing1 : Direction.values()) {
            Upgrade upgrade = this.typeUpgradeMap.get(facing1);
            if (upgrade == Upgrade.NONE) continue;
            LinkedList<Object> itemStackList = new LinkedList<Object>();
            LinkedList<ItemStack> itemStackList1 = new LinkedList<ItemStack>();
            for (int i = facing1.ordinal() * 6; i < facing1.ordinal() * 6 + 6; ++i) {
                ItemStack stack = this.slot.get(i);
                if (!stack.m_41619_() && i >= facing1.ordinal() * 6 && i < facing1.ordinal() * 6 + 3) {
                    itemStackList.add(stack);
                    continue;
                }
                if (stack.m_41619_()) continue;
                itemStackList1.add(stack);
            }
            switch (upgrade) {
                case EXTRACT: {
                    itemStackList.addAll(itemStackList1);
                    this.extract.put(facing1, itemStackList);
                    continue block5;
                }
                case PULLING: {
                    itemStackList.addAll(itemStackList1);
                    this.pulling.put(facing1, itemStackList);
                    continue block5;
                }
                case EXT_PUL: {
                    this.extract.put(facing1, itemStackList1);
                    this.pulling.put(facing1, itemStackList);
                }
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        Upgrade typeUpgrade = this.typeUpgradeMap.get(Direction.values()[(int)var2]);
        Upgrade newTypeUpgrade = Upgrade.values()[(typeUpgrade.ordinal() + 1) % 4];
        this.typeUpgradeMap.replace(Direction.values()[(int)var2], newTypeUpgrade);
        this.updateList();
    }
}

