/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.energy.event.load.EnergyTileLoadEvent;
import com.denfop.api.energy.event.unload.EnergyTileUnLoadEvent;
import com.denfop.api.energy.forgeenergy.EnergyForge;
import com.denfop.api.energy.forgeenergy.EnergyForgeSink;
import com.denfop.api.energy.forgeenergy.EnergyForgeSinkSource;
import com.denfop.api.energy.forgeenergy.EnergyForgeSource;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.blockentity.base.CooldownTracker;
import com.denfop.blocks.BlockResource;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Redstone;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.events.TickHandlerIU;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityBase
extends BlockEntity {
    public static final PlantType noCrop = PlantType.get((String)"nocrop");
    public static final List<AABB> defaultAabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    public static int ticker = 1;
    public static Map<ResourceKey<Level>, List<ChunkPos>> updates = new ConcurrentHashMap<ResourceKey<Level>, List<ChunkPos>>();
    public final MultiBlockEntity teBlock;
    public final BlockTileEntity block;
    public BlockPos pos;
    public Map<Capability<?>, AbstractComponent> capabilityComponents;
    public List<AbstractComponent> componentList = new ArrayList<AbstractComponent>();
    public List<AbstractComponent> updateServerList = new ArrayList<AbstractComponent>();
    public List<AbstractComponent> updateClientList = new ArrayList<AbstractComponent>();
    public Map<String, AbstractComponent> advComponentMap = new HashMap<String, AbstractComponent>();
    public SoilPollutionComponent pollutionSoil;
    public AirPollutionComponent pollutionAir;
    public String active = "";
    public boolean isLoaded;
    public byte facing;
    boolean hasHashCode = false;
    CooldownTracker cooldownTracker = new CooldownTracker();
    boolean loaded = false;
    private boolean isClientLoaded;
    private int hashCode;

    public BlockEntityBase(MultiBlockEntity multiBlockItem, BlockPos p_155229_, BlockState p_155230_) {
        super(multiBlockItem.getBlockType(), p_155229_, p_155230_);
        this.f_58856_ = p_155230_;
        this.teBlock = this.getTeBlock();
        this.block = this.getBlock();
        this.pos = p_155229_;
    }

    public static boolean checkSide(List<AABB> aabbs, Direction side, boolean strict) {
        AABB aabb2;
        if (aabbs == defaultAabbs) {
            return true;
        }
        int dx = side.m_122429_();
        int dy = side.m_122430_();
        int dz = side.m_122431_();
        int xS = (dx + 1) / 2;
        int yS = (dy + 1) / 2;
        int zS = (dz + 1) / 2;
        int xE = (dx + 2) / 2;
        int yE = (dy + 2) / 2;
        int zE = (dz + 2) / 2;
        if (strict) {
            for (AABB aabb2 : aabbs) {
                switch (side) {
                    case DOWN: {
                        if (!(aabb2.f_82289_ < 0.0)) break;
                        return false;
                    }
                    case UP: {
                        if (!(aabb2.f_82292_ > 1.0)) break;
                        return false;
                    }
                    case NORTH: {
                        if (!(aabb2.f_82290_ < 0.0)) break;
                        return false;
                    }
                    case SOUTH: {
                        if (!(aabb2.f_82293_ > 1.0)) break;
                        return false;
                    }
                    case WEST: {
                        if (!(aabb2.f_82288_ < 0.0)) break;
                        return false;
                    }
                    case EAST: {
                        if (!(aabb2.f_82291_ > 1.0)) break;
                        return false;
                    }
                }
            }
        }
        Iterator<AABB> var12 = aabbs.iterator();
        do {
            if (!var12.hasNext()) {
                return false;
            }
            aabb2 = var12.next();
        } while (!(aabb2.f_82288_ <= (double)xS) || !(aabb2.f_82289_ <= (double)yS) || !(aabb2.f_82290_ <= (double)zS) || !(aabb2.f_82291_ >= (double)xE) || !(aabb2.f_82292_ >= (double)yE) || !(aabb2.f_82293_ >= (double)zE));
        return true;
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.m_58904_().m_5776_()) {
            for (AbstractComponent abstractComponent : this.componentList) {
                abstractComponent.markDirty();
            }
        }
    }

    public BlockPos getPos() {
        return this.f_58858_;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.f_58857_ == null) {
            AirPollutionComponent air = this.getComp(AirPollutionComponent.class);
            SoilPollutionComponent soil = this.getComp(SoilPollutionComponent.class);
            if (air != null || soil != null) {
                if (Keyboard.isKeyDown(340)) {
                    tooltip.add(Localization.translate("iu.pollution.info1"));
                    tooltip.add(Localization.translate("iu.pollution.info2"));
                    tooltip.add(Localization.translate("iu.pollution.info3"));
                }
                tooltip.add(Localization.translate("iu.pollution.info"));
            }
        }
        for (AbstractComponent component : this.componentList) {
            component.addInformation(stack, tooltip);
        }
    }

    public boolean isChunkLoaded(@Nullable Level world, @NotNull BlockPos pos) {
        return this.isChunkLoaded(world, SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public boolean isChunkLoaded(Level accessor, int chunkX, int chunkZ) {
        if (accessor == null) {
            return false;
        }
        if (!accessor.f_46443_) {
            return accessor.m_7232_(chunkX, chunkZ);
        }
        return accessor.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false) != null;
    }

    public Level getWorld() {
        return this.m_58904_();
    }

    public void readFromNBT(CompoundTag nbt) {
        this.facing = nbt.m_128445_("facing");
        this.active = nbt.m_128461_("active");
        if (!this.componentList.isEmpty() && nbt.m_128425_("components", 10)) {
            CompoundTag componentsNbt = nbt.m_128469_("components");
            for (int i = 0; i < this.componentList.size(); ++i) {
                AbstractComponent component = this.componentList.get(i);
                CompoundTag componentNbt = componentsNbt.m_128469_("component_" + i);
                component.readFromNbt(componentNbt);
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readFromNBT(nbt);
    }

    public void onLoaded() {
        this.pos = this.f_58858_;
        this.componentList.forEach(AbstractComponent::onLoaded);
        this.rerender();
        if (!this.m_58904_().f_46443_ && this.needUpdate()) {
            IUCore.network.getServer().addTileToOvertimeUpdate(this);
        }
        this.hashCode();
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128344_("facing", this.facing);
        nbt.m_128359_("active", this.active);
        if (!this.componentList.isEmpty()) {
            CompoundTag componentsNbt = new CompoundTag();
            for (int i = 0; i < this.componentList.size(); ++i) {
                AbstractComponent component = this.componentList.get(i);
                CompoundTag nbt1 = component.writeToNbt();
                if (nbt1 == null) {
                    nbt1 = new CompoundTag();
                }
                componentsNbt.m_128365_("component_" + i, (Tag)nbt1);
            }
            nbt.m_128365_("components", (Tag)componentsNbt);
        }
        return nbt;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeToNBT(nbt);
    }

    @javax.annotation.Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        new PacketUpdateTile(this);
        return null;
    }

    public CompoundTag m_5995_() {
        new PacketUpdateTile(this);
        return super.m_5995_();
    }

    public void tick() {
        if (this.m_58901_()) {
            return;
        }
        if (this.m_58904_().f_46443_) {
            this.updateEntityClient();
        } else {
            this.updateEntityServer();
            if (ticker % 120 == 0) {
                ChunkPos chunkPos = new ChunkPos(this.f_58858_);
                if (!this.m_58901_() && !updates.computeIfAbsent((ResourceKey<Level>)this.f_58857_.m_46472_(), k -> new LinkedList()).contains(chunkPos)) {
                    updates.computeIfAbsent((ResourceKey<Level>)this.f_58857_.m_46472_(), k -> new LinkedList()).add(chunkPos);
                    this.f_58857_.m_151543_(this.f_58858_);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        this.pos = this.f_58858_;
        this.updateClientList.forEach(AbstractComponent::updateEntityClient);
        if (!this.isClientLoaded) {
            this.loadBeforeFirstClientUpdate();
        }
        if (this.cooldownTracker.getTick() > 0) {
            this.cooldownTracker.removeTick();
        }
    }

    public void loadBeforeFirstClientUpdate() {
        this.isClientLoaded = true;
    }

    public void updateEntityServer() {
        this.pos = this.f_58858_;
        if (!this.getSupportedFacings().contains(this.getFacing())) {
            for (Property property : this.f_58856_.m_61147_()) {
                if (!property.m_61708_().equals("facing")) continue;
                Direction value = (Direction)this.f_58856_.m_61143_(property);
                this.setFacing(value);
                break;
            }
        }
        for (AbstractComponent component : this.updateServerList) {
            component.updateEntityServer();
        }
        if (!this.isLoaded) {
            this.loadBeforeFirstUpdate();
        }
        if (this.cooldownTracker.getTick() > 0) {
            this.cooldownTracker.removeTick();
        }
    }

    public void m_7651_() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.m_7651_();
    }

    public void onLoad() {
        super.onLoad();
        if (!this.loaded) {
            this.loaded = true;
            Level world = this.m_58904_();
            if (this.f_58858_ != null) {
                TickHandlerIU.requestSingleWorldTick(world, world1 -> this.onLoaded());
            }
        }
    }

    public void loadBeforeFirstUpdate() {
        this.isLoaded = true;
        try {
            for (Direction direction : Direction.values()) {
                EnergyTile energyTile;
                IEnergyStorage storage;
                if (this.m_58904_().f_46443_) continue;
                BlockPos neighborPos = this.pos.m_121955_(direction.m_122436_());
                BlockEntity blockEntity = this.m_58904_().m_7702_(neighborPos);
                BlockState neighbor = this.m_58904_().m_8055_(neighborPos);
                if (!(this instanceof EnergyTile) && this.getComp(Energy.class) == null || !(neighbor.m_60734_() instanceof EntityBlock) || neighbor.m_60734_() instanceof BlockTileEntity || blockEntity == null || (storage = (IEnergyStorage)blockEntity.getCapability(ForgeCapabilities.ENERGY, ModUtils.getFacingFromTwoPositions(this.pos, neighborPos)).orElse(null)) == null || blockEntity.m_58901_() || (energyTile = EnergyNetGlobal.instance.getTile(this.f_58857_, neighborPos)) != EnergyNetGlobal.EMPTY) continue;
                EnergyForge energyForge = null;
                if (storage.canExtract() && storage.canReceive()) {
                    energyForge = new EnergyForgeSinkSource(blockEntity);
                } else if (storage.canReceive()) {
                    energyForge = new EnergyForgeSink(blockEntity);
                } else if (storage.canExtract()) {
                    energyForge = new EnergyForgeSource(blockEntity);
                }
                if (energyForge == null) continue;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), energyForge));
            }
            this.rerender();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rerender() {
        BlockState state1 = this.f_58856_;
        this.f_58856_ = null;
        BlockState state = this.m_58900_();
        if (state1 == null) {
            state1 = state;
        }
        if (this.isChunkLoaded(this.f_58857_, this.pos)) {
            this.m_58904_().m_7260_(this.f_58858_, this.f_58856_, this.f_58856_, 2);
        }
    }

    public void onClicked(Player player) {
    }

    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        if (this.componentList != null) {
            for (AbstractComponent component : this.componentList) {
                component.onNeighborChange(neighbor, neighborPos);
            }
        }
        if (!this.m_58904_().f_46443_) {
            EnergyTile energyTile;
            if (neighbor.m_60795_()) {
                EnergyTile energyTile2;
                if ((this instanceof EnergyTile || this.getComp(Energy.class) != null) && (energyTile2 = EnergyNetGlobal.instance.getTile(this.f_58857_, neighborPos)) != EnergyNetGlobal.EMPTY && energyTile2 instanceof EnergyForge) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), energyTile2));
                }
                return;
            }
            BlockEntity blockEntity = this.m_58904_().m_7702_(neighborPos);
            if (blockEntity == null || blockEntity.m_58901_()) {
                if ((this instanceof EnergyTile || this.getComp(Energy.class) != null) && (energyTile = EnergyNetGlobal.instance.getTile(this.f_58857_, neighborPos)) != EnergyNetGlobal.EMPTY && energyTile instanceof EnergyForge) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), energyTile));
                }
                return;
            }
            if ((this instanceof EnergyTile || this.getComp(Energy.class) != null) && neighbor.m_60734_() instanceof EntityBlock && !(neighbor.m_60734_() instanceof BlockTileEntity)) {
                IEnergyStorage storage = (IEnergyStorage)blockEntity.getCapability(ForgeCapabilities.ENERGY, ModUtils.getFacingFromTwoPositions(this.pos, neighborPos)).orElse(null);
                if (storage != null) {
                    EnergyTile existingTile = EnergyNetGlobal.instance.getTile(this.f_58857_, neighborPos);
                    if (existingTile != EnergyNetGlobal.EMPTY && existingTile instanceof EnergyForge) {
                        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), existingTile));
                    }
                    if (existingTile == EnergyNetGlobal.EMPTY || !(existingTile instanceof EnergyForge)) {
                        EnergyForge energyForge = null;
                        if (storage.canExtract() && storage.canReceive()) {
                            energyForge = new EnergyForgeSinkSource(blockEntity);
                        } else if (storage.canReceive()) {
                            energyForge = new EnergyForgeSink(blockEntity);
                        } else if (storage.canExtract()) {
                            energyForge = new EnergyForgeSource(blockEntity);
                        }
                        if (energyForge != null) {
                            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), energyForge));
                        }
                    }
                }
            } else if ((this instanceof EnergyTile || this.getComp(Energy.class) != null) && (energyTile = EnergyNetGlobal.instance.getTile(this.f_58857_, neighborPos)) != EnergyNetGlobal.EMPTY && energyTile instanceof EnergyForge) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), energyTile));
            }
        }
    }

    public boolean hasSpecialModel() {
        return false;
    }

    public boolean canPlace(BlockEntityBase te, BlockPos pos, Level world, Direction direction, LivingEntity entity) {
        Direction facing = this.getPlacementFacing(entity, direction);
        byte temp = this.facing;
        this.facing = (byte)facing.ordinal();
        AABB aabb = this.getAabb(false).m_82338_(pos);
        int minX = Mth.m_14107_((double)aabb.f_82288_);
        int maxX = Mth.m_14165_((double)aabb.f_82291_);
        int minY = Mth.m_14107_((double)aabb.f_82289_);
        int maxY = Mth.m_14165_((double)aabb.f_82292_);
        int minZ = Mth.m_14107_((double)aabb.f_82290_);
        int maxZ = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    checkPos.m_122178_(x, y, z);
                    BlockState state = world.m_8055_((BlockPos)checkPos);
                    if (state.m_60795_() || state.m_60812_((BlockGetter)world, (BlockPos)checkPos).m_83281_()) continue;
                    this.facing = temp;
                    return false;
                }
            }
        }
        this.facing = temp;
        return true;
    }

    public int getWeakPower(Direction side) {
        return 0;
    }

    public boolean canConnectRedstone() {
        return this.hasComponent(Redstone.class);
    }

    public boolean hasComponent(Class<? extends AbstractComponent> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return true;
        }
        return false;
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public int getLightOpacity() {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        return false;
    }

    public CooldownTracker getCooldownTracker() {
        return this.cooldownTracker;
    }

    public CustomPacketBuffer writeUpdatePacket() {
        return new CustomPacketBuffer();
    }

    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
    }

    public boolean needUpdate() {
        return false;
    }

    public CustomPacketBuffer writeContainerPacket() {
        return new CustomPacketBuffer();
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("active") || field.equals("facing")) {
            this.rerender();
        }
    }

    public boolean canEntityDestroy(Entity entity) {
        for (AbstractComponent component : this.componentList) {
            if (component.canEntityDestroy(entity)) continue;
            return false;
        }
        return true;
    }

    public List<AbstractComponent> getComponentList() {
        return this.componentList;
    }

    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack drop = this.getPickBlock(null, null);
        if ((drop = this.adjustDrop(drop, wrench, fortune)) == null) {
            drop = ItemStack.f_41583_;
        }
        if (!drop.m_41619_()) {
            for (AbstractComponent component : this.componentList) {
                if (!component.needWriteNBTToDrops()) continue;
                CompoundTag tagCompound = ModUtils.nbt(drop);
                tagCompound.m_128365_(component.toString(), (Tag)component.writeNBTToDrops(new CompoundTag()));
            }
        }
        return Collections.singletonList(drop);
    }

    public boolean wrenchCanRemove(Player player) {
        for (AbstractComponent component : this.componentList) {
            if (component.wrenchCanRemove(player)) continue;
            return false;
        }
        return this.getTeBlock().getHarvestTool() == HarvestTool.Wrench;
    }

    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        Level world = this.m_58904_();
        if ((facing = this.getPlacementFacing(placer, facing)) != this.getFacing()) {
            this.setFacing(facing);
        }
        if (world.f_46443_) {
            this.rerender();
        }
        for (AbstractComponent component : this.componentList) {
            if (component.needWriteNBTToDrops()) {
                CompoundTag tagCompound = ModUtils.nbt(stack);
                CompoundTag tag = tagCompound.m_128469_(component.toString());
                component.readFromNbt(tag);
            }
            component.onPlaced(stack, placer, facing);
        }
    }

    public AABB getVisualBoundingBox() {
        return this.getAabb(false);
    }

    public AABB getPhysicsBoundingBox() {
        return this.getAabb(true);
    }

    public AABB getOutlineBoundingBox() {
        return this.getVisualBoundingBox();
    }

    public void addCollisionBoxesToList(AABB mask, List<AABB> list, Entity collidingEntity) {
        AABB maskNormalized = mask.m_82386_((double)(-this.f_58858_.m_123341_()), (double)(-this.f_58858_.m_123342_()), (double)(-this.f_58858_.m_123343_()));
        for (AABB aabb : this.getAabbs(true)) {
            if (!aabb.m_82381_(maskNormalized)) continue;
            list.add(aabb.m_82338_(this.f_58858_));
        }
    }

    public AABB getAabb(boolean forCollision) {
        List<AABB> aabbs = this.getAabbs(forCollision);
        if (aabbs.isEmpty()) {
            throw new RuntimeException("No AABBs for " + String.valueOf((Object)this));
        }
        if (aabbs.size() == 1) {
            return aabbs.get(0);
        }
        double zS = Double.POSITIVE_INFINITY;
        double yS = Double.POSITIVE_INFINITY;
        double xS = Double.POSITIVE_INFINITY;
        double zE = Double.NEGATIVE_INFINITY;
        double yE = Double.NEGATIVE_INFINITY;
        double xE = Double.NEGATIVE_INFINITY;
        for (AABB aabb : aabbs) {
            xS = Math.min(xS, aabb.f_82288_);
            yS = Math.min(yS, aabb.f_82289_);
            zS = Math.min(zS, aabb.f_82290_);
            xE = Math.max(xE, aabb.f_82291_);
            yE = Math.max(yE, aabb.f_82292_);
            zE = Math.max(zE, aabb.f_82293_);
        }
        return new AABB(xS, yS, zS, xE, yE, zE);
    }

    public void onEntityCollision(Entity entity) {
    }

    public BlockState m_58900_() {
        if (this.f_58856_ == null) {
            try {
                this.f_58856_ = (BlockState)((BlockState)this.block.m_49966_().m_61124_((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).m_61124_(this.block.facingProperty, (Comparable)this.getFacing());
            }
            catch (Exception e) {
                this.f_58856_ = this.block.m_49966_();
            }
            return this.f_58856_;
        }
        return this.f_58856_;
    }

    public abstract MultiBlockEntity getTeBlock();

    public abstract BlockTileEntity getBlock();

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    public PlantType getPlantType() {
        return noCrop;
    }

    public <T extends AbstractComponent> T getComp(String cls) {
        for (AbstractComponent component : this.componentList) {
            if (!component.toString().trim().equals(cls)) continue;
            return (T)component;
        }
        return null;
    }

    public ItemStack getItem(Player player, HitResult target) {
        return this.block.getItemStack();
    }

    public Set<Direction> getSupportedFacings() {
        return this.teBlock.getSupportedFacings();
    }

    public List<AABB> getAabbs(boolean forCollision) {
        return defaultAabbs;
    }

    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        return this.adjustDrop(drop, wrench, WorldBaseGen.random.nextInt(100));
    }

    public Iterable<? extends AbstractComponent> getComps() {
        return this.componentList;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.capabilityComponents == null) {
            return super.getCapability(cap, side);
        }
        AbstractComponent comp = this.capabilityComponents.get(cap);
        return comp == null ? super.getCapability(cap, side) : LazyOptional.of(() -> comp.getCapability(cap, side)).cast();
    }

    public void onExploded(Explosion explosion) {
    }

    public <T extends AbstractComponent> T addComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.add(component);
        this.advComponentMap.put(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.add(component);
        }
        if (component.isServer()) {
            this.updateServerList.add(component);
        }
        for (Capability<?> capability : component.getProvidedCapabilities(null)) {
            this.addComponentCapability(capability, component);
        }
        return component;
    }

    public <T extends AbstractComponent> void removeComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.remove(component);
        this.advComponentMap.remove(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.remove(component);
        }
        if (component.isServer()) {
            this.updateServerList.remove(component);
        }
        for (Capability<?> capability : component.getProvidedCapabilities(null)) {
            this.removeComponentCapability(capability, component);
        }
    }

    public void addComponentCapability(Capability<?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        AbstractComponent prev = this.capabilityComponents.put(cap, component);
        assert (prev == null);
    }

    public void removeComponentCapability(Capability<?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        this.capabilityComponents.remove(cap, component);
    }

    public void onChunkUnloaded() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnloaded();
    }

    public void onUnloaded() {
        if (this.needUpdate()) {
            IUCore.network.getServer().removeTileToOvertimeUpdate(this);
        }
        this.componentList.forEach(AbstractComponent::onUnloaded);
        try {
            new PacketStopSound(this.getWorld(), this.m_58899_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.m_58904_().f_46443_) {
            // empty if block
        }
    }

    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        return this.m_58904_().f_46443_;
    }

    public Map<Capability<?>, AbstractComponent> getCapabilityComponents() {
        return this.capabilityComponents;
    }

    public void onBlockBreak(boolean wrench) {
        for (AbstractComponent component : this.componentList) {
            component.blockBreak();
        }
    }

    public void wrenchBreak() {
        this.onBlockBreak(true);
    }

    public boolean onRemovedByPlayer(Player player, boolean willHarvest) {
        return true;
    }

    public ItemStack getPickBlock(Player player, HitResult target) {
        return this.block.getItemStack();
    }

    public List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    public float getHardness() {
        return this.teBlock.getHardness();
    }

    public boolean getActive() {
        return this.active.contains("active");
    }

    public void setActive(String active) {
        if (this.active.equals(active)) {
            return;
        }
        this.active = active;
        if (!this.m_58904_().f_46443_) {
            new PacketUpdateFieldTile(this, "active", this.active);
        }
        if (this.isChunkLoaded(this.f_58857_, this.pos)) {
            this.getWorld().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)), 3);
        }
    }

    public void setActive(boolean active) {
        if (!active && this.active.equals("")) {
            return;
        }
        if (active) {
            if (!this.active.equals("active")) {
                this.active = "active";
                if (!this.m_58904_().f_46443_) {
                    new PacketUpdateFieldTile(this, "active", this.active);
                }
            }
        } else {
            this.active = "";
            if (!this.m_58904_().f_46443_) {
                new PacketUpdateFieldTile(this, "active", this.active);
            }
        }
        if (this.isChunkLoaded(this.f_58857_, this.pos)) {
            this.getWorld().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)), 3);
        }
    }

    public Direction getFacing() {
        return Direction.values()[this.facing];
    }

    public void setFacing(Direction facing) {
        if (facing == null) {
            throw new NullPointerException("null facing");
        }
        if (this.facing == facing.ordinal()) {
            return;
        }
        if (!this.getSupportedFacings().contains(facing)) {
            return;
        }
        this.facing = (byte)facing.ordinal();
        if (!this.m_58904_().f_46443_) {
            new PacketUpdateFieldTile(this, "facing", this.facing);
        }
        if (this.isChunkLoaded(this.f_58857_, this.pos)) {
            this.getWorld().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(this.block.facingProperty, (Comparable)this.getFacing()), 3);
        }
    }

    public boolean canSetFacingWrench(Direction facing, Player player) {
        if (!this.teBlock.allowWrenchRotating()) {
            return false;
        }
        if (facing == this.getFacing()) {
            return false;
        }
        this.setFacing(facing);
        return this.getSupportedFacings().contains(facing);
    }

    public boolean setFacingWrench(Direction facing, Player player) {
        if (!this.canSetFacingWrench(facing, player)) {
            return false;
        }
        this.setFacing(facing);
        return true;
    }

    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(this.getSelfDrops(fortune, true));
        ret.addAll(this.getAuxDrops(fortune));
        return ret;
    }

    public SoundType getBlockSound(Entity entity) {
        return SoundType.f_56742_;
    }

    public Direction getPlacementFacing(LivingEntity placer, Direction facing) {
        Set<Direction> supportedFacings = this.getSupportedFacings();
        if (supportedFacings.isEmpty()) {
            return Direction.DOWN;
        }
        if (placer != null) {
            Vec3 dir = placer.m_20154_();
            Direction bestFacing = null;
            double maxMatch = Double.NEGATIVE_INFINITY;
            for (Direction cFacing : supportedFacings) {
                double match = dir.m_82526_(Vec3.m_82528_((Vec3i)cFacing.m_122424_().m_122436_()));
                if (!(match > maxMatch)) continue;
                maxMatch = match;
                bestFacing = cFacing;
            }
            return bestFacing;
        }
        return facing != null && supportedFacings.contains(facing.m_122424_()) ? facing.m_122424_() : this.getSupportedFacings().iterator().next();
    }

    public ItemStack adjustDrop(ItemStack drop, boolean wrench, int fortune) {
        block14: {
            block13: {
                if (wrench) break block13;
                switch (this.teBlock.getDefaultDrop()) {
                    default: {
                        drop = this.getPickBlock(null, null);
                        break block14;
                    }
                    case Generator: {
                        drop = new ItemStack(IUItem.basemachine2.getItem(78), 1);
                        break block14;
                    }
                    case None: {
                        drop = null;
                        break block14;
                    }
                    case Machine: {
                        return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                    }
                    case AdvMachine: {
                        return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
                    }
                }
            }
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    drop = this.getPickBlock(null, null);
                    break;
                }
                case Generator: {
                    if (fortune >= 2) break;
                    drop = new ItemStack(IUItem.basemachine2.getItem(78), 1);
                    break;
                }
                case None: {
                    drop = null;
                    break;
                }
                case Machine: {
                    if (fortune < 2) {
                        return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                    }
                }
                case AdvMachine: {
                    if (fortune >= 2) break;
                    return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
                }
            }
        }
        return drop;
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = new CustomPacketBuffer();
        packet.writeShort(this.teBlock.getIDBlock());
        packet.writeString(this.active);
        packet.writeByte(this.facing);
        return packet;
    }

    public CompoundTag getNBTFromSlot(CustomPacketBuffer customPacketBuffer) {
        try {
            Inventory slot = (Inventory)DecoderHandler.decode(customPacketBuffer);
            return slot.writeToNbt(new CompoundTag());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("active")) {
            try {
                this.active = (String)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("facing")) {
            is.readUnsignedByte();
            this.facing = is.readByte();
        }
        this.onNetworkUpdate(name);
    }

    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        this.active = customPacketBuffer.readString();
        this.facing = customPacketBuffer.readByte();
        this.rerender();
    }

    public boolean doesSideBlockRendering(Direction side) {
        return BlockEntityBase.checkSide(this.getAabbs(false), side, false);
    }

    public <T extends AbstractComponent> T getComp(Class<T> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return (T)component;
        }
        return null;
    }
}

