/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.menu.VirtualSlot;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentPrivate;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.Register;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityInventory
extends BlockEntityBase
implements CustomWorldContainer,
WorldlyContainer {
    protected final List<Inventory> inventories = new ArrayList<Inventory>();
    protected final Map<Integer, Tuple<Integer, Integer>> indexInventoryList = new HashMap<Integer, Tuple<Integer, Integer>>();
    protected final List<Inventory> inputSlots = new LinkedList<Inventory>();
    protected final List<Inventory> outputSlots = new LinkedList<Inventory>();
    protected final IItemHandler[] itemHandler = new IItemHandler[Direction.values().length + 1];
    private final ComponentPrivate componentPrivate = this.addComponent(new ComponentPrivate(this));
    protected int size_inventory;
    protected ComponentClientEffectRender componentClientEffectRender;
    protected SoilPollutionComponent pollutionSoil;
    protected AirPollutionComponent pollutionAir;
    private int[] slotsFace;
    private int windowId;

    public BlockEntityInventory(MultiBlockEntity tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
    }

    public static int getIndex(int loc) {
        return loc >>> 16;
    }

    public void onNetworkEvent(int var1) {
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            CompoundTag invSlotsTag = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
            for (int i = 0; i < this.inventories.size(); ++i) {
                Inventory invSlot = this.inventories.get(i);
                invSlot.readFromNbt(invSlotsTag.m_128469_(String.valueOf(i)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        CompoundTag invSlotsTag = new CompoundTag();
        for (int i = 0; i < this.inventories.size(); ++i) {
            CompoundTag invSlotTag = new CompoundTag();
            Inventory invSlot = this.inventories.get(i);
            invSlot.writeToNbt(invSlotTag);
            invSlotsTag.m_128365_(String.valueOf(i), (Tag)invSlotTag);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, invSlotsTag);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        for (AbstractComponent component : this.componentList) {
            if (!component.onSneakingActivated(player, hand)) continue;
            return true;
        }
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        IUpgradableBlock upgradableBlock;
        IUpgradeItem iUpgradeItem;
        if (this.f_58857_.f_46443_) {
            return true;
        }
        for (AbstractComponent component : this.componentList) {
            if (!component.onBlockActivated(player, hand)) continue;
            return true;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() instanceof IUpgradeItem && this instanceof IUpgradableBlock && (iUpgradeItem = (IUpgradeItem)stack.m_41720_()).isSuitableFor(stack, (upgradableBlock = (IUpgradableBlock)((Object)this)).getUpgradableProperties())) {
            for (Inventory invslot : this.inventories) {
                if (!(invslot instanceof InventoryUpgrade)) continue;
                InventoryUpgrade upgrade = (InventoryUpgrade)invslot;
                if (!upgrade.add(stack)) break;
                stack.m_41764_(0);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_36096_.m_38946_();
                }
                this.m_6596_();
                return true;
            }
        }
        this.openContainer(player);
        return true;
    }

    private void openContainer(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (this.getGuiContainer(player) != null) {
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            try {
                EncoderHandler.encode(growingBuffer, this);
            }
            catch (IOException var5) {
                throw new RuntimeException(var5);
            }
            growingBuffer.flip();
            player.m_6915_();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
    }

    public Tuple<Integer, Integer> locateInfoInvSlot(int extIndex) {
        try {
            return this.indexInventoryList.get(extIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void putStackAt(Tuple<Integer, Integer> tuple, ItemStack stack) {
        this.inventories.get((Integer)tuple.m_14418_()).set((int)((Integer)tuple.m_14419_()), stack);
        super.m_6596_();
    }

    protected Inventory getInventorySlot(int extIndex) {
        Tuple<Integer, Integer> tuple = this.indexInventoryList.get(extIndex);
        return tuple == null ? null : this.inventories.get((Integer)tuple.m_14418_());
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == null) {
                if (this.itemHandler[this.itemHandler.length - 1] == null) {
                    this.itemHandler[this.itemHandler.length - 1] = new InvWrapper((Container)this);
                }
                return LazyOptional.of(() -> this.itemHandler[this.itemHandler.length - 1]).cast();
            }
            if (this.itemHandler[facing.ordinal()] == null) {
                this.itemHandler[facing.ordinal()] = new SidedInvWrapper((WorldlyContainer)this, facing);
            }
            return LazyOptional.of(() -> this.itemHandler[facing.ordinal()]).cast();
        }
        if (this.capabilityComponents == null) {
            return super.getCapability(cap, facing);
        }
        AbstractComponent comp = (AbstractComponent)this.capabilityComponents.get(cap);
        return comp == null ? super.getCapability(cap, facing) : LazyOptional.of(() -> comp.getCapability(cap, facing)).cast();
    }

    @Override
    public void addInventorySlot(Inventory inventorySlot) {
        assert (this.inventories.stream().noneMatch(slot -> slot.equals(inventorySlot)));
        this.inventories.add(inventorySlot);
    }

    @Override
    public MenuType<?> getMenuType() {
        return (MenuType)Register.containerBase.get();
    }

    @Override
    public int getContainerId() {
        return this.windowId;
    }

    @Override
    public ContainerMenuBase<?> getGuiContainer(Player var1) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return null;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }

    public int[] m_7071_(Direction p_19238_) {
        if (this.slotsFace == null) {
            this.slotsFace = new int[this.m_6643_()];
            for (int i = 0; i < this.m_6643_(); ++i) {
                this.slotsFace[i] = i;
            }
        }
        return this.slotsFace;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction p_19237_) {
        if (ModUtils.isEmpty(stack)) {
            return false;
        }
        Inventory targetSlot = this.getInventorySlot(index);
        if (targetSlot == null) {
            return false;
        }
        return targetSlot.canInput() && targetSlot.m_7013_((Integer)this.locateInfoInvSlot(index).m_14419_(), stack);
    }

    public void removeInventorySlot(Inventory inventorySlot) {
        this.inventories.remove(inventorySlot);
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        return super.getSelfDrops(fortune, wrench);
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(super.getAuxDrops(fortune));
        for (Inventory slot : this.inventories) {
            if (slot instanceof VirtualSlot) continue;
            for (ItemStack stack : slot) {
                if (ModUtils.isEmpty(stack)) continue;
                ret.add(stack);
            }
        }
        for (AbstractComponent component : this.getComponentList()) {
            if (component.getDrops().isEmpty()) continue;
            ret.addAll(component.getDrops());
        }
        return ret;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.componentPrivate.onNetworkUpdate((CustomPacketBuffer)((Object)DecoderHandler.decode(customPacketBuffer)));
            for (AbstractComponent component : this.componentList) {
                component.onNetworkUpdate(customPacketBuffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = super.writePacket();
        try {
            EncoderHandler.encode(packetBuffer, this.componentPrivate);
            for (AbstractComponent component : this.componentList) {
                packetBuffer.writeBytes((ByteBuf)component.updateComponent());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        CompoundTag invSlotsTag = nbtTagCompound.m_128469_("InvSlots");
        for (int i = 0; i < this.inventories.size(); ++i) {
            Inventory invSlot = this.inventories.get(i);
            invSlot.readFromNbt(invSlotsTag.m_128469_(String.valueOf(i)));
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        CompoundTag invSlotsTag = new CompoundTag();
        for (int i = 0; i < this.inventories.size(); ++i) {
            Inventory invSlot = this.inventories.get(i);
            CompoundTag invSlotTag = new CompoundTag();
            invSlot.writeToNbt(invSlotTag);
            invSlotsTag.m_128365_(String.valueOf(i), (Tag)invSlotTag);
        }
        nbt.m_128365_("InvSlots", (Tag)invSlotsTag);
        return nbt;
    }

    public boolean m_7157_(int index, ItemStack p_19240_, Direction p_19241_) {
        Inventory targetSlot = this.getInventorySlot(index);
        return targetSlot != null && targetSlot.canOutput();
    }

    public int m_6643_() {
        if (this.size_inventory == 0 && !this.inventories.isEmpty()) {
            for (Inventory invSlot : this.inventories) {
                this.size_inventory += invSlot.size();
            }
        }
        return this.size_inventory;
    }

    public boolean m_7983_() {
        return this.inventories.isEmpty();
    }

    public List<Inventory> getInputSlots() {
        return this.inputSlots;
    }

    public List<Inventory> getOutputSlots() {
        return this.outputSlots;
    }

    public ItemStack m_8020_(int index) {
        Tuple<Integer, Integer> tuple = this.locateInfoInvSlot(index);
        return tuple == null ? ModUtils.emptyStack : this.inventories.get((Integer)tuple.m_14418_()).m_8020_((Integer)tuple.m_14419_());
    }

    public int m_6893_() {
        return this.getInventoryStackLimit();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public ItemStack m_7407_(int index, int amount) {
        Tuple<Integer, Integer> tuple = this.locateInfoInvSlot(index);
        if (tuple == null) {
            return ModUtils.emptyStack;
        }
        ItemStack stack = this.inventories.get((Integer)tuple.m_14418_()).m_8020_((Integer)tuple.m_14419_());
        if (ModUtils.isEmpty(stack)) {
            return ModUtils.emptyStack;
        }
        if (amount >= ModUtils.getSize(stack)) {
            this.putStackAt(tuple, ModUtils.emptyStack);
            return stack;
        }
        if (amount != 0) {
            if (amount < 0) {
                int space = Math.min(this.inventories.get((Integer)tuple.m_14418_()).getStackSizeLimit(), stack.m_41741_()) - ModUtils.getSize(stack);
                amount = Math.max(amount, -space);
            }
            this.putStackAt(tuple, ModUtils.decSize(stack, amount));
        }
        ItemStack ret = stack.m_41777_();
        ret = ModUtils.setSize(ret, amount);
        return ret;
    }

    public ComponentPrivate getComponentPrivate() {
        return this.componentPrivate;
    }

    public List<Inventory> getInventories() {
        return this.inventories;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlots.clear();
        this.outputSlots.clear();
        int amount = 0;
        int index = 0;
        for (Inventory slot : this.inventories) {
            for (int k = 0; k < slot.size(); ++k) {
                this.indexInventoryList.put(amount, (Tuple<Integer, Integer>)new Tuple((Object)index, (Object)k));
                ++amount;
            }
            ++index;
            if (slot.getTypeItemSlot() == null) continue;
            if (slot.getTypeItemSlot().isInput()) {
                this.inputSlots.add(slot);
            }
            if (!slot.getTypeItemSlot().isOutput()) continue;
            this.outputSlots.add(slot);
        }
        this.size_inventory = 0;
        for (Inventory invSlot : this.inventories) {
            this.size_inventory += invSlot.size();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.componentClientEffectRender != null) {
            this.componentClientEffectRender.render();
        }
    }

    public ItemStack m_8016_(int index) {
        Tuple<Integer, Integer> tuple = this.locateInfoInvSlot(index);
        if (tuple == null) {
            return ModUtils.emptyStack;
        }
        ItemStack ret = this.inventories.get((Integer)tuple.m_14418_()).get((Integer)tuple.m_14419_());
        if (!ModUtils.isEmpty(ret)) {
            this.putStackAt(tuple, ModUtils.emptyStack);
        }
        return ret;
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        for (Inventory invSlot : this.inventories) {
            invSlot.m_6596_();
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Inventory inventory = this.getInventorySlot(index);
        return inventory != null && inventory.canInput() && inventory.m_7013_((Integer)this.locateInfoInvSlot(index).m_14419_(), stack);
    }

    public void m_6836_(int p_18944_, ItemStack stack) {
        Tuple<Integer, Integer> tuple = this.locateInfoInvSlot(p_18944_);
        if (tuple == null) {
            assert (false);
        } else {
            if (ModUtils.isEmpty(stack)) {
                stack = ModUtils.emptyStack;
            }
            this.putStackAt(tuple, stack);
        }
    }

    public boolean m_6542_(Player p_18946_) {
        return !this.m_58901_();
    }

    public void m_6211_() {
    }

    @Nonnull
    public String getName() {
        return this.getBlock().item.m_5524_();
    }

    public Component m_5446_() {
        return Component.m_237113_((String)Localization.translate(this.getName()));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, net.minecraft.world.entity.player.Inventory p_39955_, Player p_39956_) {
        this.windowId = p_39954_;
        return this.getGuiContainer(p_39956_);
    }
}

