/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuTank;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenTank;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityLiquedTank
extends BlockEntityInventory
implements IUpgradableBlock {
    public final InventoryUpgrade upgradeSlot;
    public final InventoryFluidByList containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, new Fluid[0]);
    public final InventoryFluidByList containerslot1;
    public final Fluids fluids;
    public final InventoryOutput outputSlot;
    public FluidTank fluidTank;
    public int prev = -10;
    private int old_amount;

    public BlockEntityLiquedTank(int tanksize, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.containerslot.setUsually(true);
        this.containerslot1 = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.INPUT, new Fluid[0]);
        this.containerslot1.setUsually(true);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", tanksize * 1000);
        this.outputSlot = new InventoryOutput(this, 1);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
    }

    @Override
    public int getLightValue() {
        if (this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == net.minecraft.world.level.material.Fluids.f_76191_) {
            return super.getLightValue();
        }
        return this.fluidTank.getFluid().getFluid().getFluidType().getLightLevel();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            this.fluidTank.setFluid(fluidTank1.getFluid());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && player.m_21120_(hand).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)player.m_21120_(hand).m_41720_().initCapabilities(player.m_21120_(hand), player.m_21120_(hand).m_41783_()))) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)stack.m_41783_().m_128423_("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + String.valueOf(fluidStack.getDisplayName().m_7532_()));
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.getAmount() / 1000 + " B");
        }
        tooltip.add(Localization.translate("iu.storage_fluid") + this.fluidTank.getCapacity() / 1000 + " B");
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)stack.m_41783_().m_128423_("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            this.old_amount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        if (this.fluidTank.getFluidAmount() > 0) {
            CompoundTag nbt = ModUtils.nbt(itemStackList.get(0));
            nbt.m_128365_("fluid", (Tag)this.fluidTank.getFluid().writeToNBT(new CompoundTag()));
        }
        return itemStackList;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).m_150930_(this.getPickBlock(null, null).m_41720_()) && (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self) && this.fluidTank.getFluidAmount() > 0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.m_128365_("fluid", (Tag)this.fluidTank.getFluid().writeToNBT(new CompoundTag()));
        }
        return drop;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public double gaugeLiquidScaled(double i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0.0 : (double)this.getFluidTank().getFluidAmount() * i / (double)this.getFluidTank().getCapacity();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean needsFluid() {
        return this.getFluidTank().getFluidAmount() < this.getFluidTank().getCapacity();
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            boolean need = false;
            if (this.fluidTank.getFluidAmount() != this.old_amount) {
                this.old_amount = this.fluidTank.getFluidAmount();
                need = true;
            }
            if (need) {
                new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
            }
        }
        if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.needsFluid()) {
            output = new MutableObject();
            if (this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity() && this.containerslot1.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                needsInvUpdate = this.containerslot1.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
        }
        if (this.upgradeSlot.tickNoMark() && needsInvUpdate) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.fluidTank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public ContainerMenuTank getGuiContainer(Player entityPlayer) {
        return new ContainerMenuTank(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenTank(new ContainerMenuTank(entityPlayer, this));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (!this.f_58857_.f_46443_) {
            this.setUpgradestat();
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidInput, UpgradableProperty.FluidExtract);
    }
}

