/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.IMatter;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuMultiMatter;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMultiMatter;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class BlockEntityMultiMatter
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdatableTileEvent,
IType,
IUpdateTick,
IMatter {
    public static Map<ResourceKey<Level>, Map<ChunkPos, List<IMatter>>> worldMatterMap = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<IMatter>>>();
    public final InventoryUpgrade upgradeSlot;
    public final InventoryRecipes amplifierSlot = new InventoryRecipes((BlockEntityInventory)this, "matterAmplifier", (IUpdateTick)this);
    public final InventoryOutput outputSlot;
    public final InventoryFluid containerslot;
    public final FluidTank fluidTank;
    public final float energycost;
    protected final Fluids fluids;
    private final Redstone redstone;
    private final int state = 0;
    private final int prevState = 0;
    public boolean work;
    public int scrap = 0;
    public boolean redstonePowered = false;
    private int amountScrap;
    private double lastEnergy;
    private MachineRecipe recipe;

    public BlockEntityMultiMatter(float storageEnergy, int sizeTank, float maxtempEnergy, MultiBlockEntity multiTileBlock, BlockPos pos, BlockState blockState) {
        super(Math.round(maxtempEnergy * 1.0f), 3, 1, multiTileBlock, pos, blockState);
        this.energycost = storageEnergy * 1.0f;
        this.outputSlot = new InventoryOutput(this, 1);
        this.containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, (Fluid)FluidName.fluiduu_matter.getInstance().get());
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", sizeTank * 1000, Fluids.fluidPredicate((Fluid)FluidName.fluiduu_matter.getInstance().get()), Inventory.TypeItemSlot.OUTPUT);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                BlockEntityMultiMatter.this.energy.setEnabled(input == 0);
                BlockEntityMultiMatter.this.work = input != 0;
                BlockEntityMultiMatter.this.energy.setReceivingEnabled(BlockEntityMultiMatter.this.work);
            }
        });
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(3.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.matter_work_info") + (int)this.energycost);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.scrap = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.scrap);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
            return;
        }
        this.work = !this.work;
        this.energy.setReceivingEnabled(this.work);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.scrap = nbt.m_128451_("scrap");
        this.lastEnergy = nbt.m_128459_("lastEnergy");
        this.work = nbt.m_128471_("work");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128405_("scrap", this.scrap);
        nbt.m_128347_("lastEnergy", this.lastEnergy);
        nbt.m_128379_("work", this.work);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.m_58904_().f_46443_) {
            this.setUpgradestat();
            this.amplifierSlot.load();
            this.getOutput();
            this.energy.setReceivingEnabled(this.work);
            Map<ChunkPos, List<IMatter>> chunkPosListMap = worldMatterMap.get(this.getWorld().m_46472_());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
                LinkedList<BlockEntityMultiMatter> matters = new LinkedList<BlockEntityMultiMatter>();
                matters.add(this);
                chunkPosListMap.put(chunkPos, matters);
                worldMatterMap.put((ResourceKey<Level>)this.getWorld().m_46472_(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    matters.add(this);
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.add(this);
                }
            }
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().f_46443_) {
            Map<ChunkPos, List<IMatter>> chunkPosListMap = worldMatterMap.get(this.getWorld().m_46472_());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
                LinkedList matters = new LinkedList();
                chunkPosListMap.put(chunkPos, matters);
                worldMatterMap.put((ResourceKey<Level>)this.getWorld().m_46472_(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.remove(this);
                }
            }
        }
    }

    private void getOutput() {
        this.recipe = this.amplifierSlot.process();
        this.setRecipeOutput(this.recipe);
        this.onUpdate();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.redstonePowered = false;
        if (this.work && !(this.energy.getEnergy() <= 0.0)) {
            double bonus;
            if (this.scrap > 0 && (bonus = Math.min((double)this.scrap, this.energy.getEnergy() - this.lastEnergy)) > 0.0) {
                this.energy.forceAddEnergy(5.0 * bonus);
                this.scrap = (int)((double)this.scrap - bonus);
            }
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.scrap < 10000 && this.amountScrap > 0) {
                this.recipe = this.getRecipeOutput();
                if (this.recipe != null) {
                    this.amplifierSlot.consume();
                    this.scrap += this.amountScrap;
                    if (this.amplifierSlot.m_7983_()) {
                        this.getOutput();
                    }
                }
            }
            if (this.energy.getEnergy() >= (double)this.energycost) {
                this.attemptGeneration();
            }
            if (!this.containerslot.m_7983_()) {
                this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
            }
            this.lastEnergy = this.energy.getEnergy();
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public void attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluiduu_matter.getInstance().get(), Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return p + "%";
    }

    public ContainerMenuMultiMatter getGuiContainer(Player entityPlayer) {
        return new ContainerMenuMultiMatter(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenMultiMatter((ContainerMenuMultiMatter)menu);
    }

    @Override
    public FluidTank getMatterTank() {
        return this.fluidTank;
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(BlockEntityMultiMatter.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.recipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.recipe = output;
        this.amountScrap = this.recipe == null ? 0 : this.recipe.getRecipe().getOutput().metadata.m_128451_("amount");
    }
}

