/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.bee;

import com.denfop.blockentity.bee.EnumTypeBee;
import com.denfop.blockentity.bee.EnumTypeLife;
import com.denfop.world.WorldBaseGen;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;

public class Bee {
    final long id;
    private final int maxLife;
    private final int birthTick;
    private double jelly;
    private double food;
    private boolean ill;
    private int tick;
    private EnumTypeBee typeBee;
    private EnumTypeLife type;
    private boolean isDead;
    private boolean wasBirth = false;

    public Bee(EnumTypeBee typeBee, com.denfop.api.bee.Bee bee, EnumTypeLife type, double food, int tick) {
        this.maxLife = bee.getTickLifecycles();
        this.typeBee = typeBee;
        this.type = type;
        this.id = WorldBaseGen.random.nextLong();
        this.birthTick = bee.getTickBirthRate();
        this.tick = tick;
        this.wasBirth = this.isChild();
        this.jelly = 0.0;
        this.ill = false;
        this.food = food;
    }

    public Bee(CompoundTag tagCompound) {
        this.maxLife = tagCompound.m_128448_("maxLife");
        this.ill = tagCompound.m_128471_("ill");
        this.typeBee = EnumTypeBee.values()[tagCompound.m_128445_("typeBee")];
        this.type = EnumTypeLife.values()[tagCompound.m_128445_("type")];
        this.id = WorldBaseGen.random.nextLong();
        this.birthTick = tagCompound.m_128448_("birthTick");
        this.tick = tagCompound.m_128448_("tick");
        this.jelly = (double)tagCompound.m_128448_("jelly") / 100.0;
        this.food = (double)tagCompound.m_128448_("food") / 100.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bee bee = (Bee)o;
        return this.id == bee.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128376_("maxLife", (short)this.maxLife);
        tagCompound.m_128344_("type", (byte)this.type.ordinal());
        tagCompound.m_128344_("typeBee", (byte)this.typeBee.ordinal());
        tagCompound.m_128379_("ill", this.ill);
        tagCompound.m_128376_("birthTick", (short)this.birthTick);
        tagCompound.m_128376_("tick", (short)this.tick);
        tagCompound.m_128376_("jelly", (short)(this.jelly * 100.0));
        tagCompound.m_128376_("food", (short)(this.food * 100.0));
        return tagCompound;
    }

    public boolean isChild() {
        return this.tick < this.birthTick;
    }

    public void addTick(int tick, double lifeGenome) {
        this.tick += tick;
        if (!this.isDead) {
            this.isDead = (double)this.tick > (double)this.maxLife * lifeGenome;
        }
    }

    public void addFood(double food) {
        this.food += food;
    }

    public void addJelly(double jelly) {
        this.jelly += jelly;
    }

    public void removeFood() {
        this.food -= 0.25 + 0.25 * (double)(this.isIll() ? 1 : 0);
        if (this.food <= 0.0) {
            this.food = 0.0;
            this.isDead = true;
        }
    }

    public void removeJelly() {
        this.jelly -= 0.1 + 0.1 * (double)(this.isIll() ? 1 : 0);
        if (this.jelly <= 0.0) {
            this.jelly = 0.0;
            this.isDead = true;
        }
    }

    public double getJelly() {
        return this.jelly;
    }

    public double getFood() {
        return this.food;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean b) {
        this.isDead = b;
    }

    public boolean isIll() {
        return this.ill;
    }

    public void setIll(boolean ill) {
        this.ill = ill;
    }

    public int getTick() {
        return this.tick;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public EnumTypeLife getType() {
        return this.type;
    }

    public void setType(EnumTypeLife type) {
        this.type = type;
    }

    public EnumTypeBee getTypeBee() {
        return this.typeBee;
    }

    public void setTypeBee(EnumTypeBee typeBee) {
        this.typeBee = typeBee;
    }
}

