/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.containermenu.ContainerMenuAutoFuse;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenAutoFuse;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityAutoFuse
extends BlockEntityInventory {
    public final Inventory slotBomb = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

        @Override
        public boolean m_7013_(int index, ItemStack stack) {
            return stack.m_41720_() == IUItem.nuclear_bomb.getItem();
        }
    };
    public final ComponentBaseEnergy rad_energy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 100000.0));
    private final Redstone redstone = this.addComponent(new Redstone(this));
    public boolean fuse = false;
    public int timer = 60;
    private boolean boom = false;

    public BlockEntityAutoFuse(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.autofuse, pos, state);
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                BlockEntityAutoFuse.this.fuse = !BlockEntityAutoFuse.this.fuse;
                new PacketUpdateFieldTile(BlockEntityAutoFuse.this.getParent(), "fuse", BlockEntityAutoFuse.this.fuse);
            }
        });
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.autofuse.info"));
    }

    private BlockEntityInventory getParent() {
        return this;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.autofuse;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.fuse = customPacketBuffer.readBoolean();
        this.timer = customPacketBuffer.readInt();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.fuse);
        customPacketBuffer.writeInt(this.timer);
        return customPacketBuffer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAutoFuse((ContainerMenuAutoFuse)menu);
    }

    public ContainerMenuAutoFuse getGuiContainer(Player var1) {
        return new ContainerMenuAutoFuse(this, var1);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("timer")) {
            is.readUnsignedByte();
            this.timer = is.readInt();
            if (this.timer == 0) {
                this.boom = true;
            }
        }
        if (name.equals("fuse")) {
            is.readUnsignedByte();
            this.fuse = is.readBoolean();
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128379_("fuse", this.fuse);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.fuse = nbtTagCompound.m_128471_("fuse");
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.fuse && !this.slotBomb.m_7983_() && this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                if (this.boom) {
                    this.boom = false;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
                this.timer = 60;
            } else {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(this.fuse);
        if (this.fuse && !this.slotBomb.m_7983_() && this.timer >= 0) {
            if (this.timer != 0) {
                --this.timer;
            }
            if (this.timer % 10 == 0) {
                new PacketUpdateFieldTile(this, "timer", this.timer);
            }
            if (this.timer == 0) {
                this.rad_energy.addEnergy(300.0);
                this.slotBomb.get(0).m_41774_(1);
                this.timer = 60;
            }
        }
    }
}

