/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.crop.CropItem;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGenomeExtractor;
import com.denfop.inventory.Inventory;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenGenomeExtractor;
import com.denfop.screen.ScreenIndustrialUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityGenomeExtractor
extends BlockEntityInventory
implements IUpdatableTileEvent {
    public final InventoryOutput slot = new InventoryOutput(this, 1);
    public final ComponentBaseEnergy energy;
    public final Inventory input = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

        @Override
        public boolean m_7013_(int index, ItemStack stack) {
            return stack.m_41720_() instanceof CropItem || stack.m_41720_() instanceof ItemJarBees;
        }

        @Override
        public ItemStack set(int index, ItemStack content) {
            super.set(index, content);
            if (content.m_41619_()) {
                BlockEntityGenomeExtractor.this.genBee = null;
                BlockEntityGenomeExtractor.this.genCrop = null;
            } else if (content.m_41720_() instanceof CropItem) {
                BlockEntityGenomeExtractor.this.genCrop = new com.denfop.api.crop.genetics.Genome(content);
                BlockEntityGenomeExtractor.this.genBee = null;
            } else {
                BlockEntityGenomeExtractor.this.genBee = new Genome(content);
                BlockEntityGenomeExtractor.this.genCrop = null;
            }
            return content;
        }
    };
    public com.denfop.api.crop.genetics.Genome genCrop;
    public Genome genBee;
    int meta = -1;
    private boolean work;

    public BlockEntityGenomeExtractor(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.genome_extractor, pos, state);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 1000.0));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        ItemStack stack;
        super.readContainerPacket(customPacketBuffer);
        boolean hasGenCrop = customPacketBuffer.readBoolean();
        boolean hasGenBee = customPacketBuffer.readBoolean();
        if (hasGenCrop) {
            stack = customPacketBuffer.m_130267_();
            this.genCrop = new com.denfop.api.crop.genetics.Genome(stack);
        } else {
            this.genCrop = null;
        }
        if (hasGenBee) {
            stack = customPacketBuffer.m_130267_();
            this.genBee = new Genome(stack);
        } else {
            this.genBee = null;
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.genCrop != null);
        customPacketBuffer.writeBoolean(this.genBee != null);
        if (this.genCrop != null) {
            customPacketBuffer.writeItemStack(this.genCrop.getStack(), false);
        }
        if (this.genBee != null) {
            customPacketBuffer.writeItemStack(this.genBee.getStack(), false);
        }
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.genome_extractor;
    }

    public ContainerMenuGenomeExtractor getGuiContainer(Player var1) {
        return new ContainerMenuGenomeExtractor(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGenomeExtractor((ContainerMenuGenomeExtractor)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && !this.input.get(0).m_41619_() && this.slot.m_7983_() && this.meta != -1) {
            if (this.energy.getEnergy() >= 50.0) {
                this.energy.useEnergy(50.0);
                this.work = false;
                if (this.genCrop != null) {
                    this.genCrop.removeGenome(com.denfop.api.crop.genetics.GeneticTraits.values()[this.meta], this.input.get(0));
                    this.slot.add(new ItemStack((ItemLike)IUItem.genome_crop.getStack(this.meta), 1));
                } else if (this.genBee != null) {
                    this.genBee.removeGenome(GeneticTraits.values()[this.meta], this.input.get(0));
                    this.slot.add(new ItemStack((ItemLike)IUItem.genome_bee.getStack(this.meta), 1));
                }
            }
            this.meta = -1;
        } else {
            this.work = false;
            if (this.input.get(0).m_41619_()) {
                this.genCrop = null;
                this.genBee = null;
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == -1.0) {
            this.work = true;
        } else {
            this.meta = (int)var2;
        }
    }
}

