/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine1Entity;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuMagnetGenerator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMagnetGenerator;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityMagnetGenerator
extends BlockEntityElectricMachine {
    public int timer = 86400;

    public BlockEntityMagnetGenerator(BlockPos pos, BlockState state) {
        super(0.0, 14, 1, BlockBaseMachine1Entity.magnet_generator, pos, state);
        this.energy = this.addComponent(Energy.asBasicSource(this, 3456000.0, 14));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.magnet_generator.getSoundEvent();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.magnet_generator.info"));
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.timer = nbttagcompound.m_128451_("timer");
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.timer = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.timer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("timer", this.timer);
        return nbttagcompound;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine1Entity.magnet_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        CompoundTag nbt;
        super.onPlaced(stack, placer, facing);
        if (!this.getWorld().f_46443_ && (nbt = ModUtils.nbt(stack)).m_128471_("work")) {
            this.timer = nbt.m_128451_("timer");
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> list = super.getWrenchDrops(player, fortune);
        CompoundTag nbt = ModUtils.nbt(list.get(0));
        nbt.m_128405_("timer", this.timer);
        nbt.m_128379_("work", true);
        return list;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).m_150930_(this.getPickBlock(null, null).m_41720_()) && (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self)) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.m_128405_("timer", this.timer);
            nbt.m_128379_("work", true);
        }
        return drop;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.timer == 0) {
            if (this.getActive()) {
                this.initiate(2);
                this.setActive(false);
            }
            return;
        }
        if (this.getActive() && this.f_58857_.m_46467_() % 5L == 0L) {
            ParticleUtils.spawnMagneticGeneratorParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
        }
        if (this.getWorld().m_46467_() % 20L == 0L) {
            --this.timer;
        }
        this.energy.addEnergy(2.0);
        if (!this.getActive()) {
            this.setActive(true);
            this.initiate(0);
        }
        if (this.getWorld().m_46467_() % 200L == 0L) {
            this.initiate(2);
            this.initiate(0);
        }
    }

    public String getStartSoundFile() {
        return "Machines/magnet_generator.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public ContainerMenuMagnetGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerMenuMagnetGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> b) {
        return new ScreenMagnetGenerator(new ContainerMenuMagnetGenerator(entityPlayer, this));
    }
}

