/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.research.event.RocketPadLoadEvent;
import com.denfop.api.space.research.event.RocketPadReLoadEvent;
import com.denfop.api.space.research.event.RocketPadUnLoadEvent;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuRocketLaunchPad;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.rocketpad.DataRocket;
import com.denfop.render.rocketpad.RocketPadRender;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenRocketLaunchPad;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockEntityRocketLaunchPad
extends BlockEntityInventory
implements IRocketLaunchPad {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(-1.0, 0.0, -1.0, 2.0, 2.0, 2.0));
    public final InventoryOutput outputSlot;
    public final Inventory roverSlot;
    public final Energy energy;
    public final Fluids fluids;
    public final Fluids.InternalFluidTank tank;
    public final Fluids.InternalFluidTank[] tanks;
    public List<DataRocket> rocketList = new ArrayList<DataRocket>();
    boolean added = false;
    private UUID player = new UUID(WorldBaseGen.random.nextLong(), WorldBaseGen.random.nextLong());

    public BlockEntityRocketLaunchPad(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.rocket_launch_pad, pos, state);
        this.outputSlot = new InventoryOutput(this, 27);
        this.roverSlot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof IRoversItem;
            }
        };
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 40000, Fluids.fluidPredicate((Fluid)FluidName.fluidhydrazine.getInstance().get(), (Fluid)FluidName.fluiddimethylhydrazine.getInstance().get(), (Fluid)FluidName.fluiddecane.getInstance().get(), (Fluid)FluidName.fluidxenon.getInstance().get()));
        this.tanks = new Fluids.InternalFluidTank[9];
        for (int i = 0; i < 9; ++i) {
            this.tanks[i] = this.fluids.addTankExtract("tank" + i, 10000);
        }
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 5000000.0, 14));
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.rocket_launch_pad;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 80L == 0L) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketPadReLoadEvent(this.getWorld(), this));
        }
        if (!this.roverSlot.m_7983_()) {
            this.charge(this.roverSlot.get(0));
            this.refuel(this.roverSlot.get(0), (IRoversItem)this.roverSlot.get(0).m_41720_());
        }
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            this.player = placer.m_20148_();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.player = nbtTagCompound.m_128342_("player");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128362_("player", this.player);
        return nbtTagCompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.getWorld().f_46443_) {
            GlobalRenderManager.addRender(this.f_58857_, this.pos, this.createFunction(this));
        } else if (!this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketPadLoadEvent(this.getWorld(), this));
            this.added = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Function<RenderLevelStageEvent, Void> createFunction(BlockEntityRocketLaunchPad te) {
        Function<RenderLevelStageEvent, Void> function = event -> {
            RenderSystem.setShader(GameRenderer::m_172817_);
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_252880_((float)te.getPos().m_123341_(), (float)te.getPos().m_123342_(), (float)te.getPos().m_123343_());
            event.getLevelRenderer();
            int combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)this.f_58857_, (BlockPos)this.pos);
            RocketPadRender.render(te, event.getPartialTick(), event.getPoseStack(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), combinedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            return null;
        };
        return function;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketPadUnLoadEvent(this.getWorld(), this));
            this.added = false;
        }
        if (this.getWorld().f_46443_) {
            GlobalRenderManager.removeRender(this.f_58857_, this.pos);
        }
    }

    @Override
    public void refuel(ItemStack itemStack, IRoversItem roversItem) {
        IFluidHandlerItem fluidHandler = roversItem.getFluidHandler(itemStack);
        if (this.tank.getFluidAmount() > 0 && fluidHandler.fill(this.tank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
            this.tank.drain(fluidHandler.fill(this.tank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void charge(ItemStack itemStack) {
        if (this.energy.getEnergy() > 0.0) {
            this.energy.useEnergy(ElectricItem.manager.charge(itemStack, this.energy.getEnergy(), 14, true, false));
        }
    }

    @Override
    public ItemStack getRoverStack() {
        return this.roverSlot.get(0);
    }

    @Override
    public Inventory getRoverSlot() {
        return this.roverSlot;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public Level getWorldPad() {
        return this.f_58857_;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = super.writePacket();
        packetBuffer.writeBoolean(this.roverSlot.m_7983_());
        if (!this.roverSlot.m_7983_()) {
            packetBuffer.writeItemStack(this.roverSlot.get(0), false);
        }
        return packetBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        boolean isNotEmpty = customPacketBuffer.readBoolean();
        if (!isNotEmpty) {
            this.roverSlot.set(0, customPacketBuffer.m_130267_());
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("datarocket")) {
            ItemStack stack = is.m_130267_();
            this.rocketList.add(new DataRocket((IRoversItem)stack.m_41720_(), this.pos.m_123342_()));
            this.roverSlot.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public void addDataRocket(ItemStack stack) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeString("datarocket");
        packetBuffer.writeItemStack(stack, false);
        IUCore.network.getServer().addTileFieldToUpdate(this, packetBuffer);
    }

    @Override
    public InventoryOutput getSlotOutput() {
        return this.outputSlot;
    }

    @Override
    public void addFluidStack(FluidStack fluidStack) {
        for (int i = 0; i < 9; ++i) {
            Fluids.InternalFluidTank tank = this.tanks[i];
            if (tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packetBuffer = super.writeUpdatePacket();
        packetBuffer.writeItemStack(this.roverSlot.get(0), false);
        return packetBuffer;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
        this.roverSlot.set(0, packetBuffer.m_130267_());
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    public ContainerMenuRocketLaunchPad getGuiContainer(Player var1) {
        return new ContainerMenuRocketLaunchPad(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenRocketLaunchPad((ContainerMenuRocketLaunchPad)menu);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public IRoversItem getRover() {
        if (this.roverSlot.get(0).m_41619_()) {
            return null;
        }
        return (IRoversItem)this.roverSlot.get(0).m_41720_();
    }

    @Override
    public void consumeRover() {
        this.roverSlot.set(0, ItemStack.f_41583_);
    }
}

