/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSolidStateElectrolyzer;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryElectrolyzer;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSolidStateElectrolyzer;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntitySolidStateElectrolyzer
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InventoryUpgrade upgradeSlot;
    public final InventoryRecipes inputSlotA;
    public final Fluids.InternalFluidTank fluidTank1;
    public final InventoryFluidByList fluidSlot1;
    public final InventoryOutput output1;
    public final FluidHandlerRecipe fluid_handler;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final InventoryElectrolyzer cathodeslot;
    public final InventoryElectrolyzer anodeslot;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    protected short progress;

    public BlockEntitySolidStateElectrolyzer(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3Entity.solid_state_electrolyzer, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationLength = 100;
        this.defaultOperationLength = 100;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "solid_electrolyzer", (IUpdateTick)this);
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 12000, Inventory.TypeItemSlot.OUTPUT);
        this.output1 = new InventoryOutput(this, 1);
        this.fluid_handler = new FluidHandlerRecipe("solid_electrolyzer", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidSlot1 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot1.setTypeFluidSlot(InventoryFluid.TypeFluidSlot.OUTPUT);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.cathodeslot = new InventoryElectrolyzer(this, 1);
        this.anodeslot = new InventoryElectrolyzer(this, 0);
    }

    public static void addRecipe(ItemStack container, ItemStack output, FluidStack ... fluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("solid_electrolyzer", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, output)));
        Recipes.recipes.getRecipeFluid().addRecipe("solid_electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container), Arrays.asList(fluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "200" + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + "1");
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuSolidStateElectrolyzer getGuiContainer(Player var1) {
        return new ContainerMenuSolidStateElectrolyzer(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSolidStateElectrolyzer((ContainerMenuSolidStateElectrolyzer)menu);
    }

    @Override
    public void init() {
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.iudust.getStack(42)), new ItemStack((ItemLike)IUItem.iudust.getStack(15)), new FluidStack((Fluid)FluidName.fluidbromine.getInstance().get(), 50));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.iudust.getStack(43)), new ItemStack((ItemLike)IUItem.iudust.getStack(41)), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 20));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)Blocks.f_50129_), new ItemStack((ItemLike)IUItem.smalldust.getStack(1)), new FluidStack((Fluid)FluidName.fluidcarbondioxide.getInstance().get(), 10));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.iudust.getStack(63)), new ItemStack((ItemLike)IUItem.iudust.getStack(14), 3), new FluidStack((Fluid)FluidName.fluidchlorum.getInstance().get(), 80));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.preciousgem.getStack(0)), new ItemStack((ItemLike)IUItem.smalldust.getStack(11), 5), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 20));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.preciousgem.getStack(1)), new ItemStack((ItemLike)IUItem.smalldust.getStack(2), 5), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 20));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.preciousgem.getStack(2)), new ItemStack((ItemLike)IUItem.smalldust.getStack(10), 5), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 20));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone.getItem(0)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(30), 3), new FluidStack((Fluid)FluidName.fluidbromine.getInstance().get(), 50));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone.getItem(5)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(35), 3), new FluidStack((Fluid)FluidName.fluidhelium.getInstance().get(), 50));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone.getItem(6)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(36), 3), new FluidStack((Fluid)FluidName.fluidmethane.getInstance().get(), 50));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone.getItem(10)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(40), 3), new FluidStack((Fluid)FluidName.fluidcarbonmonoxide.getInstance().get(), 50));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone.getItem(14)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(44), 3), new FluidStack((Fluid)FluidName.fluidnitrogen.getInstance().get(), 100));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(2)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(48), 3), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 100));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(3)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(49), 3), new FluidStack((Fluid)FluidName.fluidethane.getInstance().get(), 100));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(5)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(51), 3), new FluidStack((Fluid)FluidName.fluidnitricacid.getInstance().get(), 100));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(6)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(52), 3), new FluidStack((Fluid)FluidName.fluidxenon.getInstance().get(), 80));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(7)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(53), 3), new FluidStack((Fluid)FluidName.fluidnitrogenhydride.getInstance().get(), 100));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(8)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(54), 3), new FluidStack((Fluid)FluidName.fluiddecane.getInstance().get(), 80));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(10)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(56), 3), new FluidStack((Fluid)FluidName.fluidchlorum.getInstance().get(), 80));
        BlockEntitySolidStateElectrolyzer.addRecipe(new ItemStack((ItemLike)IUItem.space_stone1.getItem(11)), new ItemStack((ItemLike)IUItem.spaceItem.getStack(57), 3), new FluidStack((Fluid)FluidName.fluidiodine.getInstance().get(), 80));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.solid_electrolyzer.getSoundEvent();
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.solid_state_electrolyzer;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            this.getOutput();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MutableObject output1 = new MutableObject();
        boolean check = false;
        if (this.fluidTank1.getFluidAmount() >= 1000 && this.fluidSlot1.transferFromTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.output1.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferFromTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output1.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
        if (check || this.fluid_handler.output() == null && this.output != null) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.output == null) {
            this.fluid_handler.setOutput(null);
        }
        if (this.cathodeslot.m_7983_() || this.anodeslot.m_7983_()) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
            return;
        }
        if (this.output != null && !this.inputSlotA.m_7983_() && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.inputSlotA.continue_process(this.output) && this.fluid_handler.output() != null && this.fluid_handler.canFillFluid() && this.energy.canUseEnergy(this.energyConsume)) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            ItemStack cathode = this.cathodeslot.get(0);
            ItemStack anode = this.anodeslot.get(0);
            if (cathode.m_41773_() < cathode.m_41776_()) {
                cathode.m_41721_(cathode.m_41773_() + 1);
            }
            if (anode.m_41773_() < anode.m_41776_()) {
                anode.m_41721_(anode.m_41773_() + 1);
            }
            if (cathode.m_41773_() == cathode.m_41776_()) {
                this.cathodeslot.consume(1);
            }
            if (anode.m_41773_() == anode.m_41776_()) {
                this.anodeslot.consume(1);
            }
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.addAll(this.output.getRecipe().getOutput().items);
        this.fluid_handler.fillFluid();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

