/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockSqueezerEntity;
import com.denfop.componets.Fluids;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntitySqueezer
extends BlockEntityInventory
implements IUpdateTick,
IHasRecipe {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, -0.5, 1.0, 1.7, 1.5));
    private static final List<AABB> aabbs1 = Collections.singletonList(new AABB(-0.5, 0.0, 0.0, 1.5, 1.7, 1.0));
    public final InventoryRecipes inputSlotA = new InventoryRecipes(this, "squeezer", this){

        @Override
        public boolean m_7013_(int index, ItemStack itemStack) {
            if (index == 4) {
                return super.m_7013_(0, itemStack);
            }
            return false;
        }
    };
    public final Fluids.InternalFluidTank fluidTank1;
    public final InventoryFluidByList fluidSlot1;
    public final FluidHandlerRecipe fluid_handler;
    public short progress = 0;
    public Map<UUID, Double> data;
    private MachineRecipe output;

    public BlockEntitySqueezer(BlockPos pos, BlockState state) {
        super(BlockSqueezerEntity.squeezer, pos, state);
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 12000, Inventory.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("squeezer", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidSlot1 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot1.setTypeFluidSlot(InventoryFluid.TypeFluidSlot.OUTPUT);
        this.inputSlotA.setStackSizeLimit(1);
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addRecipe(ItemStack container, FluidStack fluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("squeezer", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, container)));
        Recipes.recipes.getRecipeFluid().addRecipe("squeezer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container), Collections.singletonList(fluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 5; ++i) {
            tooltip.add(Localization.translate("squeezer.info" + i));
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void init() {
        BlockEntitySqueezer.addRecipe(new ItemStack((ItemLike)IUItem.rawLatex.getItem()), new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100));
        BlockEntitySqueezer.addRecipe(new ItemStack((ItemLike)Items.f_42404_), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 10));
        BlockEntitySqueezer.addRecipe(new ItemStack((ItemLike)Items.f_42578_), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 35));
        BlockEntitySqueezer.addRecipe(new ItemStack((ItemLike)Items.f_42577_), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 35));
        BlockEntitySqueezer.addRecipe(new ItemStack((ItemLike)IUItem.crops.getStack(0)), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 50));
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return Collections.singletonList(new AABB(0.0, 0.0, -0.5, 1.0, 1.7, 1.5));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.squeezer.getBlock();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockSqueezerEntity.squeezer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.m_58904_().f_46443_) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.SQUEEZER);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.m_21120_(hand);
        if (this.f_58857_.f_46443_) {
            return true;
        }
        if (stack.m_41720_().equals(IUItem.treetap.getItem()) && !this.inputSlotA.m_7983_() && this.output != null && this.fluid_handler.output() != null && this.fluid_handler.canFillFluid()) {
            this.progress = (short)(this.progress + (short)(20 + (short)(this.data.getOrDefault(player.m_20148_(), 0.0) / 15.0)));
            this.getCooldownTracker().setTick(10);
            this.setActive(String.valueOf(this.progress / 20));
            if (this.progress >= 100) {
                this.progress = 0;
                this.setActive("");
                if (!this.getWorld().f_46443_) {
                    PrimitiveHandler.addExperience(EnumPrimitive.SQUEEZER, 0.5, player.m_20148_());
                }
                this.fluid_handler.fillFluid();
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
            }
            return this.getWorld().f_46443_;
        }
        if (!stack.m_41619_() && this.inputSlotA.m_7013_(4, stack)) {
            if (this.inputSlotA.get(0).m_41619_()) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                this.inputSlotA.set(0, stack1);
                stack.m_41774_(1);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.getWorld().f_46443_ && player.m_21120_(hand).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)stack.m_41720_().initCapabilities(stack, stack.m_41783_()))) != null && this.fluidTank1.getFluidAmount() >= 1000) {
                ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(ForgeCapabilities.FLUID_HANDLER, side));
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
                return true;
            }
            if (!this.inputSlotA.m_7983_()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.f_41583_);
                this.output = null;
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && !this.inputSlotA.m_7983_()) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.inputSlotA.m_7983_()) {
            this.fluid_handler.setOutput(null);
        }
    }
}

